

<?php $__env->startSection('title', 'System Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-cog me-2"></i>System Settings
        </h1>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Settings Navigation -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <ul class="nav nav-pills nav-fill" id="settingsTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="general-tab" data-bs-toggle="tab" 
                                    data-bs-target="#general" type="button" role="tab">
                                <i class="fas fa-building me-2"></i>General
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="contact-tab" data-bs-toggle="tab" 
                                    data-bs-target="#contact" type="button" role="tab">
                                <i class="fas fa-address-book me-2"></i>Contact
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="tax-tab" data-bs-toggle="tab" 
                                    data-bs-target="#tax" type="button" role="tab">
                                <i class="fas fa-calculator me-2"></i>Tax Configuration
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="notifications-tab" data-bs-toggle="tab" 
                                    data-bs-target="#notifications" type="button" role="tab">
                                <i class="fas fa-bell me-2"></i>Notifications
                            </button>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Settings Content -->
    <div class="tab-content" id="settingsContent">
        <!-- General Settings -->
        <div class="tab-pane fade show active" id="general" role="tabpanel">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-building me-2"></i>General Settings</h5>
                </div>
                <form action="<?php echo e(route('admin.settings.general')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="row">
                            <!-- Company Information -->
                            <div class="col-md-6">
                                <h6 class="text-primary mb-3">Company Information</h6>
                                
                                <div class="mb-3">
                                    <label for="company_name" class="form-label">Company Name</label>
                                    <input type="text" class="form-control" id="company_name" name="company_name" 
                                           value="<?php echo e(old('company_name', \App\Models\Setting::get('company_name', 'Kenya Import Tax Simulator'))); ?>" required>
                                </div>

                                <div class="mb-3">
                                    <label for="company_address" class="form-label">Company Address</label>
                                    <textarea class="form-control" id="company_address" name="company_address" 
                                              rows="3"><?php echo e(old('company_address', \App\Models\Setting::get('company_address', ''))); ?></textarea>
                                </div>

                                <div class="mb-3">
                                    <label for="company_phone" class="form-label">Company Phone</label>
                                    <input type="text" class="form-control" id="company_phone" name="company_phone" 
                                           value="<?php echo e(old('company_phone', \App\Models\Setting::get('company_phone', ''))); ?>">
                                </div>
                            </div>

                            <!-- Application Settings -->
                            <div class="col-md-6">
                                <h6 class="text-primary mb-3">Application Settings</h6>

                                <!-- Logo Upload -->
                                <div class="mb-3">
                                    <label class="form-label">Application Logo</label>
                                    <div class="d-flex align-items-center">
                                        <?php
                                            $appLogo = \App\Models\Setting::get('app_logo');
                                        ?>
                                        <?php if($appLogo && Storage::disk('public')->exists($appLogo)): ?>
                                            <img src="<?php echo e(Storage::disk('public')->url($appLogo)); ?>" 
                                                 alt="App Logo" class="img-thumbnail me-3" style="max-height: 80px;">
                                            <button type="button" class="btn btn-outline-danger btn-sm" 
                                                    onclick="removeLogo()">
                                                <i class="fas fa-trash me-1"></i>Remove
                                            </button>
                                        <?php else: ?>
                                            <div class="text-muted me-3">
                                                <i class="fas fa-image fa-2x"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <input type="file" class="form-control mt-2" id="app_logo" name="app_logo" 
                                           accept="image/*">
                                    <div class="form-text">Recommended: 200x60px PNG or JPG, max 2MB</div>
                                </div>

                                <div class="mb-3">
                                    <label for="default_currency" class="form-label">Default Currency</label>
                                    <select class="form-control" id="default_currency" name="default_currency" required>
                                        <option value="KES" <?php echo e((\App\Models\Setting::get('default_currency', 'KES') == 'KES') ? 'selected' : ''); ?>>KES - Kenyan Shilling</option>
                                        <option value="USD" <?php echo e((\App\Models\Setting::get('default_currency', 'KES') == 'USD') ? 'selected' : ''); ?>>USD - US Dollar</option>
                                        <option value="EUR" <?php echo e((\App\Models\Setting::get('default_currency', 'KES') == 'EUR') ? 'selected' : ''); ?>>EUR - Euro</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="default_timezone" class="form-label">Default Timezone</label>
                                    <select class="form-control" id="default_timezone" name="default_timezone" required>
                                        <?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($timezone); ?>" <?php echo e((\App\Models\Setting::get('default_timezone', 'Africa/Nairobi') == $timezone) ? 'selected' : ''); ?>>
                                                <?php echo e($timezone); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="date_format" class="form-label">Date Format</label>
                                    <select class="form-control" id="date_format" name="date_format" required>
                                        <option value="d/m/Y" <?php echo e((\App\Models\Setting::get('date_format', 'd/m/Y') == 'd/m/Y') ? 'selected' : ''); ?>>DD/MM/YYYY</option>
                                        <option value="m/d/Y" <?php echo e((\App\Models\Setting::get('date_format', 'd/m/Y') == 'm/d/Y') ? 'selected' : ''); ?>>MM/DD/YYYY</option>
                                        <option value="Y-m-d" <?php echo e((\App\Models\Setting::get('date_format', 'd/m/Y') == 'Y-m-d') ? 'selected' : ''); ?>>YYYY-MM-DD</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Save General Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Contact Settings -->
        <div class="tab-pane fade" id="contact" role="tabpanel">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-address-book me-2"></i>Contact Settings</h5>
                </div>
                <form action="<?php echo e(route('admin.settings.contact')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="contact_email" class="form-label">Contact Email</label>
                                    <input type="email" class="form-control" id="contact_email" name="contact_email" 
                                           value="<?php echo e(old('contact_email', \App\Models\Setting::get('contact_email', 'support@taxsimulator.co.ke'))); ?>" required>
                                </div>

                                <div class="mb-3">
                                    <label for="whatsapp_number" class="form-label">WhatsApp Number</label>
                                    <input type="text" class="form-control" id="whatsapp_number" name="whatsapp_number" 
                                           value="<?php echo e(old('whatsapp_number', \App\Models\Setting::get('whatsapp_number', '254700000000'))); ?>" required>
                                    <div class="form-text">Format: 254700000000 (without +)</div>
                                </div>

                                <div class="mb-3">
                                    <label for="support_phone" class="form-label">Support Phone</label>
                                    <input type="text" class="form-control" id="support_phone" name="support_phone" 
                                           value="<?php echo e(old('support_phone', \App\Models\Setting::get('support_phone', ''))); ?>">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="office_address" class="form-label">Office Address</label>
                                    <textarea class="form-control" id="office_address" name="office_address" 
                                              rows="4"><?php echo e(old('office_address', \App\Models\Setting::get('office_address', ''))); ?></textarea>
                                </div>

                                <div class="mb-3">
                                    <label for="business_hours" class="form-label">Business Hours</label>
                                    <input type="text" class="form-control" id="business_hours" name="business_hours" 
                                           value="<?php echo e(old('business_hours', \App\Models\Setting::get('business_hours', 'Mon-Fri 8:00 AM - 5:00 PM'))); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Save Contact Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Tax Configuration -->
        <div class="tab-pane fade" id="tax" role="tabpanel">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-calculator me-2"></i>Tax Configuration</h5>
                </div>
                <form action="<?php echo e(route('admin.settings.tax')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="default_tax_version" class="form-label">Default Tax Version</label>
                                    <input type="text" class="form-control" id="default_tax_version" name="default_tax_version" 
                                           value="<?php echo e(old('default_tax_version', \App\Models\Setting::get('default_tax_version', '2024'))); ?>" required>
                                </div>

                                <div class="mb-3">
                                    <label for="calculation_precision" class="form-label">Calculation Precision</label>
                                    <input type="number" class="form-control" id="calculation_precision" name="calculation_precision" 
                                           value="<?php echo e(old('calculation_precision', \App\Models\Setting::get('calculation_precision', '2'))); ?>" 
                                           min="0" max="8" required>
                                    <div class="form-text">Number of decimal places for tax calculations</div>
                                </div>

                                <div class="mb-3">
                                    <label for="exchange_rate_margin" class="form-label">Exchange Rate Margin (%)</label>
                                    <input type="number" class="form-control" id="exchange_rate_margin" name="exchange_rate_margin" 
                                           value="<?php echo e(old('exchange_rate_margin', \App\Models\Setting::get('exchange_rate_margin', '0'))); ?>" 
                                           step="0.01" min="0" max="10" required>
                                    <div class="form-text">Margin to add to exchange rates for calculations</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="auto_update_exchange_rates" 
                                               name="auto_update_exchange_rates" value="1" 
                                               <?php echo e((\App\Models\Setting::get('auto_update_exchange_rates', '1') == '1') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="auto_update_exchange_rates">
                                            Auto-update Exchange Rates
                                        </label>
                                    </div>
                                    <div class="form-text">Automatically update exchange rates daily</div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="enable_benchmarks" 
                                               name="enable_benchmarks" value="1" 
                                               <?php echo e((\App\Models\Setting::get('enable_benchmarks', '1') == '1') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="enable_benchmarks">
                                            Enable Benchmarks
                                        </label>
                                    </div>
                                    <div class="form-text">Enable benchmark comparisons in calculations</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Save Tax Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Notification Settings -->
        <div class="tab-pane fade" id="notifications" role="tabpanel">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-bell me-2"></i>Notification Settings</h5>
                </div>
                <form action="<?php echo e(route('admin.settings.notifications')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="text-primary mb-3">Email Notifications</h6>

                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="admin_email_notifications" 
                                               name="admin_email_notifications" value="1" 
                                               <?php echo e((\App\Models\Setting::get('admin_email_notifications', '1') == '1') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="admin_email_notifications">
                                            Admin Email Notifications
                                        </label>
                                    </div>
                                    <div class="form-text">Send email notifications to administrators</div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="user_email_notifications" 
                                               name="user_email_notifications" value="1" 
                                               <?php echo e((\App\Models\Setting::get('user_email_notifications', '1') == '1') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="user_email_notifications">
                                            User Email Notifications
                                        </label>
                                    </div>
                                    <div class="form-text">Send email notifications to users</div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <h6 class="text-primary mb-3">System Alerts</h6>

                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="system_health_alerts" 
                                               name="system_health_alerts" value="1" 
                                               <?php echo e((\App\Models\Setting::get('system_health_alerts', '1') == '1') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="system_health_alerts">
                                            System Health Alerts
                                        </label>
                                    </div>
                                    <div class="form-text">Receive alerts for system health issues</div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="backup_reminders" 
                                               name="backup_reminders" value="1" 
                                               <?php echo e((\App\Models\Setting::get('backup_reminders', '1') == '1') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="backup_reminders">
                                            Backup Reminders
                                        </label>
                                    </div>
                                    <div class="form-text">Receive reminders for system backups</div>
                                </div>

                                <div class="mb-3">
                                    <label for="low_stock_threshold" class="form-label">Low Stock Threshold</label>
                                    <input type="number" class="form-control" id="low_stock_threshold" name="low_stock_threshold" 
                                           value="<?php echo e(old('low_stock_threshold', \App\Models\Setting::get('low_stock_threshold', '10'))); ?>" 
                                           min="0">
                                    <div class="form-text">Threshold for low stock alerts</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Save Notification Settings
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Remove Logo Confirmation Modal -->
<div class="modal fade" id="removeLogoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Remove Logo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to remove the current logo?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="<?php echo e(route('admin.settings.remove-logo')); ?>" method="POST" id="removeLogoForm">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Remove Logo</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function removeLogo() {
    const modal = new bootstrap.Modal(document.getElementById('removeLogoModal'));
    modal.show();
}

// Initialize tab functionality
document.addEventListener('DOMContentLoaded', function() {
    const tabs = document.querySelectorAll('#settingsTabs .nav-link');
    tabs.forEach(tab => {
        tab.addEventListener('click', function() {
            tabs.forEach(t => t.classList.remove('active'));
            this.classList.add('active');
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>