

<?php $__env->startSection('title', 'Kenya Import Tax Calculator'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header Section -->
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-primary mb-3">Kenya Import Tax Calculator</h1>
                <p class="lead text-muted">Calculate import duties, taxes, and fees for goods imported into Kenya</p>
            </div>

            <!-- Calculator Form -->
            <div class="card border-0 shadow-lg">
                <div class="card-header bg-primary text-white py-3">
                    <h4 class="mb-0"><i class="ti ti-calculator me-2"></i>Tax Calculation Form</h4>
                </div>
                <div class="card-body p-4">
                    <form id="taxCalculatorForm" action="<?php echo e(route('calculator.calculate')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <!-- HS Code Section -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="hs_code" class="form-label fw-semibold">HS Code *</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control form-control-lg" 
                                               id="hs_code" name="hs_code" 
                                               placeholder="e.g., 870321" required
                                               value="<?php echo e(old('hs_code')); ?>">
                                        <button type="button" class="btn btn-outline-secondary" 
                                                data-bs-toggle="modal" data-bs-target="#hsCodeModal">
                                            <i class="ti ti-search me-1"></i>Browse
                                        </button>
                                    </div>
                                    <div class="form-text">Enter 6-10 digit Harmonized System code</div>
                                    <div id="hsCodeDetails" class="mt-2"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description" class="form-label fw-semibold">Goods Description</label>
                                    <textarea class="form-control" id="description" name="description" 
                                              rows="2" placeholder="Describe the goods being imported..."><?php echo e(old('description')); ?></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Country & Currency Section -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="country_of_origin" class="form-label fw-semibold">Country of Origin *</label>
                                    <select class="form-select form-select-lg" id="country_of_origin" name="country_of_origin" required>
                                        <option value="">Select Country</option>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->code); ?>" <?php echo e(old('country_of_origin') == $country->code ? 'selected' : ''); ?>>
                                                <?php echo e($country->name); ?>

                                                <?php if($country->region): ?>
                                                    (<?php echo e($country->region); ?>)
                                                <?php endif; ?>
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency" class="form-label fw-semibold">Transaction Currency</label>
                                    <select class="form-select form-select-lg" id="currency" name="currency">
                                        <option value="KES" selected>KES - Kenyan Shilling</option>
                                        <option value="USD">USD - US Dollar</option>
                                        <option value="EUR">EUR - Euro</option>
                                        <option value="GBP">GBP - British Pound</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Value & Quantity Section -->
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="cif_value" class="form-label fw-semibold">CIF Value (KES) *</label>
                                    <input type="number" step="0.01" class="form-control form-control-lg" 
                                           id="cif_value" name="cif_value" 
                                           placeholder="0.00" required
                                           value="<?php echo e(old('cif_value')); ?>">
                                    <div class="form-text">Cost + Insurance + Freight in KES</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="weight" class="form-label fw-semibold">Weight (KG)</label>
                                    <input type="number" step="0.01" class="form-control form-control-lg" 
                                           id="weight" name="weight" 
                                           placeholder="0.00"
                                           value="<?php echo e(old('weight')); ?>">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="quantity" class="form-label fw-semibold">Quantity</label>
                                    <input type="number" class="form-control form-control-lg" 
                                           id="quantity" name="quantity" 
                                           placeholder="1"
                                           value="<?php echo e(old('quantity', 1)); ?>">
                                </div>
                            </div>
                        </div>

                        <!-- Additional Options -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="card bg-light border-0">
                                    <div class="card-body">
                                        <h6 class="fw-semibold mb-3"><i class="ti ti-settings me-2"></i>Additional Options</h6>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="include_vat" name="include_vat" value="1" checked>
                                                    <label class="form-check-label" for="include_vat">
                                                        Include VAT (16%)
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="include_idf" name="include_idf" value="1" checked>
                                                    <label class="form-check-label" for="include_idf">
                                                        Include IDF (2.5%)
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="include_rdl" name="include_rdl" value="1" checked>
                                                    <label class="form-check-label" for="include_rdl">
                                                        Include RDL (2%)
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <button type="reset" class="btn btn-outline-secondary btn-lg me-md-2">
                                        <i class="ti ti-refresh me-2"></i>Reset
                                    </button>
                                    <button type="submit" class="btn btn-primary btn-lg" id="calculateBtn">
                                        <i class="ti ti-calculator me-2"></i>Calculate Taxes
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Quick Info Section -->
            <div class="row mt-4">
                <div class="col-md-4">
                    <div class="card border-0 bg-light h-100">
                        <div class="card-body text-center">
                            <i class="ti ti-help text-primary fs-1 mb-3"></i>
                            <h5>Need Help?</h5>
                            <p class="text-muted">Find the right HS code for your products</p>
                            <a href="<?php echo e(route('assistance')); ?>" class="btn btn-outline-primary">Get Assistance</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-0 bg-light h-100">
                        <div class="card-body text-center">
                            <i class="ti ti-file-text text-success fs-1 mb-3"></i>
                            <h5>Documentation</h5>
                            <p class="text-muted">Learn about import procedures and requirements</p>
                            <a href="<?php echo e(route('about')); ?>" class="btn btn-outline-success">Learn More</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-0 bg-light h-100">
                        <div class="card-body text-center">
                            <i class="ti ti-headset text-info fs-1 mb-3"></i>
                            <h5>Support</h5>
                            <p class="text-muted">Contact our support team for assistance</p>
                            <a href="<?php echo e(route('contact')); ?>" class="btn btn-outline-info">Contact Us</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- HS Code Modal -->
<div class="modal fade" id="hsCodeModal" tabindex="-1" aria-labelledby="hsCodeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="hsCodeModalLabel">Browse HS Codes</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="input-group mb-3">
                    <input type="text" class="form-control" id="hsSearch" placeholder="Search HS codes or descriptions...">
                    <button class="btn btn-primary" type="button" id="searchHsCodes">
                        <i class="ti ti-search me-1"></i>Search
                    </button>
                </div>
                <div class="table-responsive" style="max-height: 400px;">
                    <table class="table table-hover">
                        <thead class="table-light sticky-top">
                            <tr>
                                <th>HS Code</th>
                                <th>Description</th>
                                <th>Duty Type</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="hsCodeResults">
                            <?php $__currentLoopData = $popularHsCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hsCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($hsCode->hs_code); ?></strong></td>
                                <td><?php echo e(Str::limit($hsCode->description, 60)); ?></td>
                                <td>
                                    <span class="badge bg-info"><?php echo e(ucfirst($hsCode->default_duty_type)); ?></span>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-outline-primary select-hs-code" 
                                            data-code="<?php echo e($hsCode->hs_code); ?>" 
                                            data-description="<?php echo e($hsCode->description); ?>">
                                        Select
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 12px;
}

.form-control-lg, .form-select-lg {
    border-radius: 8px;
}

.btn-lg {
    border-radius: 8px;
    padding: 12px 24px;
}

.modal-content {
    border-radius: 12px;
}

.table th {
    border-top: none;
    font-weight: 600;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // HS Code selection from modal
    document.querySelectorAll('.select-hs-code').forEach(button => {
        button.addEventListener('click', function() {
            const code = this.getAttribute('data-code');
            const description = this.getAttribute('data-description');
            
            document.getElementById('hs_code').value = code;
            document.getElementById('description').value = description;
            
            // Close modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('hsCodeModal'));
            modal.hide();
            
            // Show HS code details
            showHsCodeDetails(code);
        });
    });

    // Real-time HS code lookup
    document.getElementById('hs_code').addEventListener('blur', function() {
        const code = this.value.trim();
        if (code.length >= 4) {
            showHsCodeDetails(code);
        }
    });

    // HS code search in modal
    document.getElementById('searchHsCodes').addEventListener('click', function() {
        searchHsCodes();
    });

    document.getElementById('hsSearch').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            searchHsCodes();
        }
    });
});

function showHsCodeDetails(code) {
    fetch(`/api/hs-codes/${code}`)
        .then(response => response.json())
        .then(data => {
            const detailsDiv = document.getElementById('hsCodeDetails');
            if (data.error) {
                detailsDiv.innerHTML = `<div class="alert alert-warning py-2">
                    <i class="ti ti-alert-triangle me-2"></i>HS Code not found
                </div>`;
            } else {
                detailsDiv.innerHTML = `
                    <div class="alert alert-success py-2">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <strong>${data.hs_code}</strong>: ${data.description}
                            </div>
                            <div>
                                <span class="badge bg-info me-2">${data.duty_type}</span>
                                ${data.excise_applicable ? '<span class="badge bg-warning">Excise</span>' : ''}
                                ${data.sensitive ? '<span class="badge bg-danger">Sensitive</span>' : ''}
                            </div>
                        </div>
                    </div>
                `;
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function searchHsCodes() {
    const query = document.getElementById('hsSearch').value;
    
    fetch(`/api/hs-codes?search=${encodeURIComponent(query)}`)
        .then(response => response.json())
        .then(data => {
            const resultsBody = document.getElementById('hsCodeResults');
            resultsBody.innerHTML = '';
            
            data.forEach(hsCode => {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td><strong>${hsCode.hs_code}</strong></td>
                    <td>${hsCode.description.substring(0, 60)}${hsCode.description.length > 60 ? '...' : ''}</td>
                    <td><span class="badge bg-info">${hsCode.default_duty_type}</span></td>
                    <td>
                        <button type="button" class="btn btn-sm btn-outline-primary select-hs-code" 
                                data-code="${hsCode.hs_code}" 
                                data-description="${hsCode.description}">
                            Select
                        </button>
                    </td>
                `;
                resultsBody.appendChild(row);
                
                // Re-attach event listener
                row.querySelector('.select-hs-code').addEventListener('click', function() {
                    const code = this.getAttribute('data-code');
                    const description = this.getAttribute('data-description');
                    
                    document.getElementById('hs_code').value = code;
                    document.getElementById('description').value = description;
                    
                    const modal = bootstrap.Modal.getInstance(document.getElementById('hsCodeModal'));
                    modal.hide();
                    
                    showHsCodeDetails(code);
                });
            });
        });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/calculator/index.blade.php ENDPATH**/ ?>