<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom px-3">
    <!-- Sidebar Toggle Button -->
    <button class="btn btn-outline-secondary me-3" id="sidebarToggle">
        <i class="ti ti-menu-2"></i>
    </button>

    <!-- Brand with Logo -->
    <a class="navbar-brand fw-bold d-flex align-items-center" href="<?php echo e(route('admin.dashboard')); ?>">
        <?php
            use App\Models\Setting;
            use Illuminate\Support\Facades\Storage;
            
            $appLogo = Setting::get('app_logo');
            $companyName = Setting::get('company_name', 'Kenya Import Tax Simulator');
        ?>
        
        <?php if($appLogo && Storage::disk('public')->exists($appLogo)): ?>
            <img src="<?php echo e(Storage::disk('public')->url($appLogo)); ?>" alt="<?php echo e($companyName); ?>" style="height: 40px; max-width: 200px;" class="me-2">
        <?php else: ?>
            <i class="fas fa-calculator text-primary me-2"></i>
            <?php echo e($companyName); ?>

        <?php endif; ?>
    </a>

    <!-- Right Side -->
    <ul class="navbar-nav ms-auto align-items-center">
        <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                <i class="ti ti-user me-1"></i> <?php echo e(Auth::user()->name); ?>

            </a>
            <div class="dropdown-menu dropdown-menu-end">
                <a href="<?php echo e(route('admin.profile')); ?>" class="dropdown-item">
                    <i class="ti ti-user me-1"></i> Profile
                </a>
                <a href="<?php echo e(route('admin.settings.index')); ?>" class="dropdown-item">
                    <i class="ti ti-settings me-1"></i> Settings
                </a>
                <div class="dropdown-divider"></div>
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="dropdown-item">
                        <i class="ti ti-logout me-1"></i> Logout
                    </button>
                </form>
            </div>
        </li>
    </ul>
</nav><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/partials/admin/topbar.blade.php ENDPATH**/ ?>