<!-- Sidebar Start -->
<aside class="left-sidebar">
    <div>
        <nav class="sidebar-nav">
            <ul id="sidebarnav" class="list-unstyled">

                <!-- Main -->
                <li class="nav-small-cap">
                    <i class="ti ti-dots"></i>
                    <span class="hide-menu">Main</span>
                </li>
                <li class="sidebar-item">
                    <a class="sidebar-link" href="<?php echo e(route('admin.dashboard')); ?>">
                        <i class="ti ti-layout-dashboard"></i>
                        <span class="hide-menu">Dashboard</span>
                    </a>
                </li>

                <!-- Tax Configuration (Collapsible) -->
                <li class="nav-small-cap">
                    <i class="ti ti-dots"></i>
                    <span class="hide-menu">Tax Configuration</span>
                </li>
                <li class="sidebar-item">
                    <a class="sidebar-link" data-bs-toggle="collapse" href="#taxConfigMenu" role="button" aria-expanded="false" aria-controls="taxConfigMenu">
                        <i class="ti ti-percentage"></i>
                        <span class="hide-menu">Manage Tax</span>
                        <i class="ti ti-chevron-down float-end"></i>
                    </a>
                    <ul class="collapse list-unstyled ps-3" id="taxConfigMenu">
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'hs-codes.view')): ?>
                        <li><a href="<?php echo e(route('admin.hs-codes.index')); ?>" class="sidebar-link">HS Codes</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'tax-configs.view')): ?>
                        <li><a href="<?php echo e(route('admin.tax-configs.index')); ?>" class="sidebar-link">Tax Configurations</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'benchmarks.view')): ?>
                        <li><a href="<?php echo e(route('admin.benchmarks.index')); ?>" class="sidebar-link">Benchmarks</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'country-overrides.view')): ?>
                        <li><a href="<?php echo e(route('admin.country-overrides.index')); ?>" class="sidebar-link">Country Overrides</a></li>
                        <?php endif; ?>
                    </ul>
                </li>

                <!-- Financial (Collapsible) -->
                <li class="nav-small-cap">
                    <i class="ti ti-dots"></i>
                    <span class="hide-menu">Financial</span>
                </li>
                <li class="sidebar-item">
                    <a class="sidebar-link" data-bs-toggle="collapse" href="#financeMenu" role="button" aria-expanded="false" aria-controls="financeMenu">
                        <i class="ti ti-currency-dollar"></i>
                        <span class="hide-menu">Financial Settings</span>
                        <i class="ti ti-chevron-down float-end"></i>
                    </a>
                    <ul class="collapse list-unstyled ps-3" id="financeMenu">
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'currencies.view')): ?>
                        <li><a href="<?php echo e(route('admin.currencies.index')); ?>" class="sidebar-link">Currencies</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'exchange-rates.view')): ?>
                        <li><a href="<?php echo e(route('admin.exchange-rates.index')); ?>" class="sidebar-link">Exchange Rates</a></li>
                        <?php endif; ?>
                    </ul>
                </li>

                <!-- Calculator -->
                <li class="nav-small-cap">
                    <i class="ti ti-dots"></i>
                    <span class="hide-menu">Calculator</span>
                </li>
                <li class="sidebar-item">
                    <a class="sidebar-link" href="<?php echo e(route('calculator')); ?>" target="_blank">
                        <i class="ti ti-calculator"></i>
                        <span class="hide-menu">Public Calculator</span>
                    </a>
                </li>
                <li class="sidebar-item">
                    <a class="sidebar-link" href="<?php echo e(route('admin.tax-calculator')); ?>">
                        <i class="ti ti-calculator-filled"></i>
                        <span class="hide-menu">Admin Calculator</span>
                    </a>
                </li>

                <!-- Management (Collapsible) -->
                <li class="nav-small-cap">
                    <i class="ti ti-dots"></i>
                    <span class="hide-menu">Management</span>
                </li>
                <li class="sidebar-item">
                    <a class="sidebar-link" data-bs-toggle="collapse" href="#managementMenu" role="button" aria-expanded="false" aria-controls="managementMenu">
                        <i class="ti ti-users"></i>
                        <span class="hide-menu">Management</span>
                        <i class="ti ti-chevron-down float-end"></i>
                    </a>
                    <ul class="collapse list-unstyled ps-3" id="managementMenu">
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'countries.view')): ?>
                        <li><a href="<?php echo e(route('admin.countries.index')); ?>" class="sidebar-link">Countries</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'calculation-logs.view')): ?>
                        <li><a href="<?php echo e(route('admin.calculation-logs.index')); ?>" class="sidebar-link">Calculation Logs</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'audit-logs.view')): ?>
                        <li><a href="<?php echo e(route('admin.audit-logs')); ?>" class="sidebar-link">Audit Logs</a></li>
                        <?php endif; ?>
                        
                        <!-- User Management Section - Only for users who can manage users or first admin -->
                        <?php if(auth()->user()->canManageUsers() || auth()->user()->isFirstAdmin()): ?>
                        <li><a href="<?php echo e(route('admin.users.index')); ?>" class="sidebar-link">User Management</a></li>
                        <?php endif; ?>
                        
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'faqs.view')): ?>
                        <li><a href="<?php echo e(route('admin.faqs.index')); ?>" class="sidebar-link">FAQs</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'contact-submissions.view')): ?>
                        <li><a href="<?php echo e(route('admin.contact-submissions.index')); ?>" class="sidebar-link">Contact Submissions</a></li>
                        <?php endif; ?>
                    </ul>
                </li>

                <!-- System (Collapsible) -->
                <li class="nav-small-cap">
                    <i class="ti ti-dots"></i>
                    <span class="hide-menu">System</span>
                </li>
                <li class="sidebar-item">
                    <a class="sidebar-link" data-bs-toggle="collapse" href="#systemMenu" role="button" aria-expanded="false" aria-controls="systemMenu">
                        <i class="ti ti-settings"></i>
                        <span class="hide-menu">System Tools</span>
                        <i class="ti ti-chevron-down float-end"></i>
                    </a>
                    <ul class="collapse list-unstyled ps-3" id="systemMenu">
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'settings.view')): ?>
                        <li><a href="<?php echo e(route('admin.settings.index')); ?>" class="sidebar-link">Settings</a></li>
                        <?php endif; ?>
                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'reports.view')): ?>
                        <li><a href="<?php echo e(route('admin.reports.index')); ?>" class="sidebar-link">Reports</a></li>
                        <?php endif; ?>
                        
                        <!-- Role Management - Only for super admins or first admin -->
                        <?php if(auth()->user()->canManageRoles() || auth()->user()->isFirstAdmin()): ?>
                        <li><a href="<?php echo e(route('admin.roles.index')); ?>" class="sidebar-link">Role Management</a></li>
                        <?php endif; ?>
                        
                        <li><a href="<?php echo e(route('admin.system-health.index')); ?>" class="sidebar-link">System Health</a></li>
                        <li><a href="<?php echo e(route('admin.api-docs')); ?>" class="sidebar-link">API Documentation</a></li>
                    </ul>
                </li>

                <!-- First Admin Badge -->
                <?php if(auth()->user()->isFirstAdmin()): ?>
                <li class="nav-small-cap mt-5">
                    <i class="ti ti-crown text-warning"></i>
                    <span class="hide-menu text-warning">First Administrator</span>
                </li>
                <li class="sidebar-item">
                    <div class="sidebar-link text-center">
                        <div class="badge bg-warning text-dark p-2">
                            <i class="ti ti-crown me-1"></i>
                            Full System Access
                        </div>
                        <small class="text-muted d-block mt-1">You have all permissions</small>
                    </div>
                </li>
                <?php endif; ?>

            </ul>
        </nav>
    </div>
</aside>
<!-- Sidebar End --><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/partials/admin/sidebar.blade.php ENDPATH**/ ?>