

<?php $__env->startSection('title', 'Exchange Rates Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-exchange-alt me-2"></i>Exchange Rates Management
                        </h4>
                        <a href="<?php echo e(route('admin.exchange-rates.create')); ?>" class="btn btn-light btn-sm">
                            <i class="fas fa-plus me-1"></i>Add Exchange Rate
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <form action="<?php echo e(route('admin.exchange-rates.index')); ?>" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="base_currency" class="form-label">Base Currency</label>
                                    <select class="form-control" id="base_currency" name="base_currency">
                                        <option value="">All Base Currencies</option>
                                        <?php $__currentLoopData = $currencies ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($currency->code); ?>" 
                                                <?php echo e(request('base_currency') == $currency->code ? 'selected' : ''); ?>>
                                                <?php echo e($currency->code); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="target_currency" class="form-label">Target Currency</label>
                                    <select class="form-control" id="target_currency" name="target_currency">
                                        <option value="">All Target Currencies</option>
                                        <?php $__currentLoopData = $currencies ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($currency->code != 'KES'): ?>
                                            <option value="<?php echo e($currency->code); ?>" 
                                                <?php echo e(request('target_currency') == $currency->code ? 'selected' : ''); ?>>
                                                <?php echo e($currency->code); ?>

                                            </option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_active" class="form-label">Status</label>
                                    <select class="form-control" id="is_active" name="is_active">
                                        <option value="">All Status</option>
                                        <option value="1" <?php echo e(request('is_active') === '1' ? 'selected' : ''); ?>>Active</option>
                                        <option value="0" <?php echo e(request('is_active') === '0' ? 'selected' : ''); ?>>Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="effective_date" class="form-label">Effective Date</label>
                                    <input type="date" class="form-control" id="effective_date" name="effective_date" 
                                           value="<?php echo e(request('effective_date')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Apply Filters</button>
                                <a href="<?php echo e(route('admin.exchange-rates.index')); ?>" class="btn btn-secondary">Clear Filters</a>
                            </div>
                        </div>
                    </form>

                    <?php if($exchangeRates->count()): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Base Currency</th>
                                    <th>Target Currency</th>
                                    <th>Exchange Rate</th>
                                    <th>Effective Date</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $exchangeRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <span class="badge bg-success"><?php echo e($rate->base_currency); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary"><?php echo e($rate->target_currency); ?></span>
                                    </td>
                                    <td>
                                        <strong>1 <?php echo e($rate->target_currency); ?> = <?php echo e(number_format($rate->rate, 4)); ?> <?php echo e($rate->base_currency); ?></strong>
                                    </td>
                                    <td><?php echo e($rate->effective_date->format('M j, Y')); ?></td>
                                    <td>
                                        <?php if($rate->is_active): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo e($rate->created_at->format('M j, Y')); ?></small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('admin.exchange-rates.edit', $rate->id)); ?>" 
                                               class="btn btn-warning" title="Edit Rate">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <?php if($rate->is_active): ?>
                                            <form action="<?php echo e(route('admin.exchange-rates.destroy', $rate->id)); ?>" 
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger" 
                                                        title="Deactivate Rate"
                                                        onclick="return confirm('Are you sure you want to deactivate this exchange rate?')">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </form>
                                            <?php else: ?>
                                            <form action="<?php echo e(route('admin.exchange-rates.update', $rate->id)); ?>" 
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <input type="hidden" name="is_active" value="1">
                                                <button type="submit" class="btn btn-success" 
                                                        title="Activate Rate"
                                                        onclick="return confirm('Are you sure you want to activate this exchange rate?')">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div class="text-muted">
                            Showing <?php echo e($exchangeRates->firstItem()); ?> to <?php echo e($exchangeRates->lastItem()); ?> of <?php echo e($exchangeRates->total()); ?> exchange rates
                        </div>
                        <?php echo e($exchangeRates->links()); ?>

                    </div>
                    <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No Exchange Rates Found</h5>
                        <p class="text-muted mb-4">No exchange rates have been added yet.</p>
                        <a href="<?php echo e(route('admin.exchange-rates.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add First Exchange Rate
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/admin/exchange-rates/index.blade.php ENDPATH**/ ?>