

<?php $__env->startSection('title', 'Countries Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Countries Management</h2>
                <a href="<?php echo e(route('admin.countries.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Country
                </a>
            </div>
            <p class="text-muted">Manage countries and trade regions for duty calculations</p>
        </div>
    </div>
</div>

<?php echo $__env->make('partials.admin.alerts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Search and Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form action="<?php echo e(route('admin.countries.index')); ?>" method="GET">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="search">Search</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="<?php echo e(request('search')); ?>" placeholder="Search country name or code...">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="region">Region</label>
                        <select class="form-control" id="region" name="region">
                            <option value="">All Regions</option>
                            <option value="EAC" <?php echo e(request('region') == 'EAC' ? 'selected' : ''); ?>>EAC</option>
                            <option value="COMESA" <?php echo e(request('region') == 'COMESA' ? 'selected' : ''); ?>>COMESA</option>
                            <option value="EU" <?php echo e(request('region') == 'EU' ? 'selected' : ''); ?>>European Union</option>
                            <option value="OTHER" <?php echo e(request('region') == 'OTHER' ? 'selected' : ''); ?>>Other</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="active">Status</label>
                        <select class="form-control" id="active" name="active">
                            <option value="">All Status</option>
                            <option value="1" <?php echo e(request('active') == '1' ? 'selected' : ''); ?>>Active</option>
                            <option value="0" <?php echo e(request('active') == '0' ? 'selected' : ''); ?>>Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Countries Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">Countries</h4>
        <a href="<?php echo e(route('admin.countries.create')); ?>" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add New
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Code</th>
                        <th>Country Name</th>
                        <th>Region</th>
                        <th>Status</th>
                        <th>Duty Overrides</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <strong><?php echo e($country->code); ?></strong>
                        </td>
                        <td><?php echo e($country->name); ?></td>
                        <td>
                            <?php if($country->region): ?>
                                <span class="badge bg-info"><?php echo e($country->region); ?></span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($country->active): ?>
                                <span class="badge bg-success">Active</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($country->dutyOverrides()->count() > 0 ? 'warning' : 'light'); ?>">
                                <?php echo e($country->dutyOverrides()->count()); ?> override(s)
                            </span>
                        </td>
                        <td>
                            <?php echo $__env->make('partials.admin.tables.action-buttons', [
                                'viewUrl' => route('admin.countries.show', $country->id),
                                'editUrl' => route('admin.countries.edit', $country->id),
                                'deleteUrl' => route('admin.countries.destroy', $country->id)
                            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <?php if($countries->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($countries->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/admin/countries/index.blade.php ENDPATH**/ ?>