<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', company_name()); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- MaterialM Admin CSS -->
    <link href="<?php echo e(asset('assets/css/styles.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/icons/font-awesome/css/fontawesome.min.css')); ?>" rel="stylesheet">
    
    <!-- Font Awesome for additional icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Custom Styles for Guest Pages -->
    <style>
        .guest-body {
            background: #f5f7fb;
            min-height: 100vh;
            font-family: 'Roboto', sans-serif;
        }
        
        .guest-navbar {
            background: #ffffff;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .guest-content {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            margin: 2rem auto;
        }
        
        .guest-footer {
            background: #2c3e50;
            color: white;
            padding: 2rem 0;
            margin-top: 3rem;
        }
        
        .brand-text {
            font-weight: 700;
            color: #3498db !important;
            font-size: 1.4rem;
        }
        
        .nav-link {
            font-weight: 500;
            color: #2c3e50 !important;
            padding: 0.5rem 1rem !important;
            border-radius: 5px;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover, .nav-link.active {
            background: #3498db;
            color: white !important;
        }
    </style>
</head>
<body class="guest-body">

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light guest-navbar">
        <div class="container">
            <a class="navbar-brand brand-text" href="<?php echo e(route('home')); ?>">
                <?php if(app_logo()): ?>
                    <img src="<?php echo e(app_logo()); ?>" 
                         alt="<?php echo e(company_name()); ?>" 
                         height="30" class="me-2">
                <?php else: ?>
                    <i class="fas fa-calculator me-2"></i>
                <?php endif; ?>
                <?php echo e(company_name()); ?>

            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('home')); ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('calculator')); ?>">Calculator</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('assistance')); ?>">HS Code Assistance</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('about')); ?>">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="<?php echo e(route('contact')); ?>">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="container">
        <div class="guest-content">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <!-- Footer -->
    <footer class="guest-footer">
        <div class="container">
            <div class="row">
                <div class="col-md-4">
                    <h5 class="mb-3"><?php echo e(company_name()); ?></h5>
                    <p class="text-light">Accurate tax calculations for your import needs. Get instant estimates for customs duties, VAT, and other taxes.</p>
                </div>
                <div class="col-md-4">
                    <h5 class="mb-3">Quick Links</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="<?php echo e(route('calculator')); ?>" class="text-light text-decoration-none"><i class="fas fa-arrow-right me-2"></i>Tax Calculator</a></li>
                        <li class="mb-2"><a href="<?php echo e(route('assistance')); ?>" class="text-light text-decoration-none"><i class="fas fa-arrow-right me-2"></i>HS Code Assistance</a></li>
                        <li class="mb-2"><a href="<?php echo e(route('about')); ?>" class="text-light text-decoration-none"><i class="fas fa-arrow-right me-2"></i>About Us</a></li>
                        <li><a href="<?php echo e(route('contact')); ?>" class="text-light text-decoration-none"><i class="fas fa-arrow-right me-2"></i>Contact</a></li>
                    </ul>
                </div>
                <div class="col-md-4">
                    <h5 class="mb-3">Contact Info</h5>
                    <ul class="list-unstyled text-light">
                        <li class="mb-2">
                            <i class="fas fa-envelope me-2"></i> 
                            <?php echo e(setting('contact_email', 'dev@eflixdigital.com')); ?>

                        </li>
                        <li class="mb-2">
                            <i class="fab fa-whatsapp me-2"></i> 
                            <?php echo e(setting('whatsapp_number', '+254 736857813')); ?>

                        </li>
                        <li class="mb-2">
                            <i class="fas fa-phone me-2"></i> 
                            <?php echo e(setting('support_phone', '+254 736857813')); ?>

                        </li>
                        <li>
                            <i class="fas fa-clock me-2"></i> 
                            <?php echo e(setting('business_hours', 'Mon-Fri: 8AM-5PM EAT')); ?>

                        </li>
                    </ul>
                </div>
            </div>
            <hr class="my-4 bg-light">
            <div class="row">
                <div class="col-md-12 text-center">
                    <p class="mb-0">&copy; <?php echo e(date('Y')); ?> <?php echo e(company_name()); ?>. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- MaterialM Admin JS Files -->
    <script src="<?php echo e(asset('assets/js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sidebarmenu.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/dashboard.js')); ?>"></script>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap 5 JS (for modals) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- CSRF Token for AJAX -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/layouts/guest.blade.php ENDPATH**/ ?>