

<?php $__env->startSection('title', 'Reports & Analytics'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-chart-bar me-2"></i>Reports & Analytics
        </h1>
    </div>

    <!-- Report Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Tax Collection
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Revenue Overview
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('admin.reports.tax-collection')); ?>" class="btn btn-primary btn-sm">
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                HS Code Analysis
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Product Analysis
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-barcode fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('admin.reports.hs-code-analysis')); ?>" class="btn btn-success btn-sm">
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Country Analysis
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Import Origins
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-globe fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('admin.reports.country-analysis')); ?>" class="btn btn-info btn-sm">
                            View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Custom Reports
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Generate Report
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cogs fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#generateReportModal">
                            Generate
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-tachometer-alt me-2"></i>Quick Statistics
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 text-center">
                            <div class="border rounded p-3">
                                <div class="text-primary mb-2">
                                    <i class="fas fa-calculator fa-2x"></i>
                                </div>
                                <h3 class="text-primary"><?php echo e(number_format(\App\Models\CalculationLog::count())); ?></h3>
                                <p class="mb-0">Total Calculations</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="border rounded p-3">
                                <div class="text-success mb-2">
                                    <i class="fas fa-money-bill fa-2x"></i>
                                </div>
                                <h3 class="text-success">KES <?php echo e(number_format(\App\Models\CalculationLog::sum('total_payable'), 2)); ?></h3>
                                <p class="mb-0">Total Revenue</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="border rounded p-3">
                                <div class="text-info mb-2">
                                    <i class="fas fa-barcode fa-2x"></i>
                                </div>
                                <h3 class="text-info"><?php echo e(number_format(\App\Models\HsCode::count())); ?></h3>
                                <p class="mb-0">HS Codes</p>
                            </div>
                        </div>
                        <div class="col-md-3 text-center">
                            <div class="border rounded p-3">
                                <div class="text-warning mb-2">
                                    <i class="fas fa-globe fa-2x"></i>
                                </div>
                                <h3 class="text-warning"><?php echo e(number_format(\App\Models\Country::count())); ?></h3>
                                <p class="mb-0">Countries</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-success text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-chart-line me-2"></i>Recent Calculations
                    </h6>
                </div>
                <div class="card-body">
                    <?php
                        $recentCalculations = \App\Models\CalculationLog::with('user')
                            ->latest()
                            ->take(5)
                            ->get();
                    ?>
                    
                    <?php if($recentCalculations->count() > 0): ?>
                        <div class="list-group list-group-flush">
                            <?php $__currentLoopData = $recentCalculations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $calculation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">
                                            HS: 
                                            <?php
                                                // Handle both array and JSON string input
                                                if (is_array($calculation->input)) {
                                                    $hsCode = $calculation->input['hs_code'] ?? 'N/A';
                                                } else {
                                                    $inputData = json_decode($calculation->input, true);
                                                    $hsCode = $inputData['hs_code'] ?? 'N/A';
                                                }
                                            ?>
                                            <?php echo e($hsCode); ?>

                                        </h6>
                                        <small class="text-muted">
                                            <?php echo e($calculation->created_at->diffForHumans()); ?>

                                        </small>
                                    </div>
                                    <span class="badge bg-primary rounded-pill">
                                        KES <?php echo e(number_format($calculation->total_payable, 2)); ?>

                                    </span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted text-center mb-0">No calculations found.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-chart-pie me-2"></i>Popular HS Codes
                    </h6>
                </div>
                <div class="card-body">
                    <?php
                        $popularHsCodes = \App\Models\CalculationLog::selectRaw('
                            CASE 
                                WHEN JSON_VALID(input) THEN JSON_UNQUOTE(JSON_EXTRACT(input, "$.hs_code"))
                                ELSE NULL
                            END as hs_code, 
                            COUNT(*) as count
                        ')
                        ->whereNotNull('input')
                        ->groupBy('hs_code')
                        ->orderByDesc('count')
                        ->take(5)
                        ->get();
                    ?>
                    
                    <?php if($popularHsCodes->count() > 0): ?>
                        <div class="list-group list-group-flush">
                            <?php $__currentLoopData = $popularHsCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->hs_code): ?>
                                    <?php
                                        $hsCode = \App\Models\HsCode::where('hs_code', $item->hs_code)->first();
                                    ?>
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="mb-1"><?php echo e($item->hs_code); ?></h6>
                                            <small class="text-muted">
                                                <?php echo e($hsCode->description ?? 'Unknown'); ?>

                                            </small>
                                        </div>
                                        <span class="badge bg-info rounded-pill">
                                            <?php echo e($item->count); ?> calculations
                                        </span>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted text-center mb-0">No HS code data available.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Generate Report Modal -->
<div class="modal fade" id="generateReportModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Generate Custom Report</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="<?php echo e(route('admin.reports.generate')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="report_type" class="form-label">Report Type</label>
                        <select class="form-control" id="report_type" name="report_type" required>
                            <option value="">Select Report Type</option>
                            <option value="tax_collection">Tax Collection Report</option>
                            <option value="hs_code_analysis">HS Code Analysis</option>
                            <option value="country_analysis">Country Analysis</option>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="start_date" class="form-label">Start Date</label>
                                <input type="date" class="form-control" id="start_date" name="start_date" 
                                       value="<?php echo e(now()->subDays(30)->format('Y-m-d')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="end_date" class="form-label">End Date</label>
                                <input type="date" class="form-control" id="end_date" name="end_date" 
                                       value="<?php echo e(now()->format('Y-m-d')); ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="format" class="form-label">Output Format</label>
                        <select class="form-control" id="format" name="format" required>
                            <option value="html">HTML (Web View)</option>
                            <option value="pdf">PDF Document</option>
                            <option value="csv">CSV Export</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-download me-2"></i>Generate Report
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/admin/reports/index.blade.php ENDPATH**/ ?>