

<?php $__env->startSection('title', 'Contact Us - ' . company_name()); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header Section -->
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-primary mb-3">Contact Us</h1>
                <p class="lead text-muted">Get in touch with our team for support, inquiries, or assistance with import tax calculations</p>
            </div>

            <!-- Contact Options Cards -->
            <div class="row mb-5">
                <!-- WhatsApp Card -->
                <div class="col-md-4 mb-4">
                    <div class="card border-0 shadow-sm h-100 text-center contact-option" 
                         onclick="openWhatsApp()" style="cursor: pointer;">
                        <div class="card-body p-4">
                            <div class="mb-4">
                                <i class="fab fa-whatsapp text-success" style="font-size: 3rem;"></i>
                            </div>
                            <h4 class="text-success mb-3">WhatsApp</h4>
                            <p class="text-muted mb-4">Chat with us instantly on WhatsApp for quick assistance</p>
                            <div class="badge bg-success">Instant Response</div>
                        </div>
                    </div>
                </div>
                
                <!-- Email Card -->
                <div class="col-md-4 mb-4">
                    <div class="card border-0 shadow-sm h-100 text-center contact-option" 
                         onclick="openEmail()" style="cursor: pointer;">
                        <div class="card-body p-4">
                            <div class="mb-4">
                                <i class="fas fa-envelope text-primary" style="font-size: 3rem;"></i>
                            </div>
                            <h4 class="text-primary mb-3">Email Us</h4>
                            <p class="text-muted mb-4">Send us an email and we'll get back to you within 24 hours</p>
                            <div class="badge bg-primary">24h Response</div>
                        </div>
                    </div>
                </div>
                
                <!-- Contact Form Card -->
                <div class="col-md-4 mb-4">
                    <div class="card border-0 shadow-sm h-100 text-center contact-option" 
                         onclick="openContactForm()" style="cursor: pointer;">
                        <div class="card-body p-4">
                            <div class="mb-4">
                                <i class="fas fa-headset text-info" style="font-size: 3rem;"></i>
                            </div>
                            <h4 class="text-info mb-3">Contact Form</h4>
                            <p class="text-muted mb-4">Fill out our contact form for detailed inquiries</p>
                            <div class="badge bg-info">Detailed Support</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional Information -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card border-0 bg-light">
                        <div class="card-body">
                            <h4 class="text-primary mb-4"><i class="fas fa-clock me-2"></i>Support Hours</h4>
                            <div class="row">
                                <div class="col-6">
                                    <strong>Monday - Friday</strong><br>
                                    8:00 AM - 5:00 PM EAT
                                </div>
                                <div class="col-6">
                                    <strong>Saturday</strong><br>
                                    9:00 AM - 1:00 PM EAT
                                </div>
                            </div>
                            <div class="mt-3">
                                <strong>Sunday & Holidays</strong><br>
                                Closed
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card border-0 bg-light">
                        <div class="card-body">
                            <h4 class="text-primary mb-4"><i class="fas fa-info-circle me-2"></i>Quick Links</h4>
                            <ul class="list-unstyled">
                                <li class="mb-2">
                                    <a href="<?php echo e(route('calculator')); ?>" class="text-decoration-none">
                                        <i class="fas fa-calculator me-2 text-primary"></i>Tax Calculator
                                    </a>
                                </li>
                                <li class="mb-2">
                                    <a href="<?php echo e(route('assistance')); ?>" class="text-decoration-none">
                                        <i class="fas fa-question-circle me-2 text-primary"></i>HS Code Assistance
                                    </a>
                                </li>
                                <li class="mb-2">
                                    <a href="<?php echo e(route('about')); ?>" class="text-decoration-none">
                                        <i class="fas fa-book me-2 text-primary"></i>About Us
                                    </a>
                                </li>
                                <li>
                                    <a href="#faq" class="text-decoration-none">
                                        <i class="fas fa-comments me-2 text-primary"></i>FAQ
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- FAQ Section -->
            <?php if($faqs->count() > 0): ?>
            <div class="card border-0 shadow-sm mt-5" id="faq">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><i class="fas fa-question-circle me-2"></i>Frequently Asked Questions</h4>
                </div>
                <div class="card-body">
                    <div class="accordion" id="faqAccordion">
                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button <?php echo e($index > 0 ? 'collapsed' : ''); ?>" 
                                        type="button" 
                                        data-bs-toggle="collapse" 
                                        data-bs-target="#faq<?php echo e($faq->id); ?>">
                                    <?php echo e($faq->question); ?>

                                </button>
                            </h2>
                            <div id="faq<?php echo e($faq->id); ?>" 
                                 class="accordion-collapse collapse <?php echo e($index === 0 ? 'show' : ''); ?>" 
                                 data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    <?php echo nl2br(e($faq->answer)); ?>

                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Contact Form Modal -->
<div class="modal fade" id="contactFormModal" tabindex="-1" aria-labelledby="contactFormModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="contactFormModalLabel">
                    <i class="fas fa-headset me-2"></i>Contact Form
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="contactForm" action="<?php echo e(route('contact.submit')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="name" class="form-label fw-semibold">Full Name *</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="email" class="form-label fw-semibold">Email Address *</label>
                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="email" name="email" value="<?php echo e(old('email')); ?>" required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="phone" class="form-label fw-semibold">Phone Number</label>
                                <input type="tel" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="phone" name="phone" value="<?php echo e(old('phone')); ?>">
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="subject" class="form-label fw-semibold">Subject *</label>
                                <select class="form-control <?php $__errorArgs = ['subject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="subject" name="subject" required>
                                    <option value="">Select a subject</option>
                                    <option value="Tax Calculation Help" <?php echo e(old('subject') == 'Tax Calculation Help' ? 'selected' : ''); ?>>Tax Calculation Help</option>
                                    <option value="HS Code Assistance" <?php echo e(old('subject') == 'HS Code Assistance' ? 'selected' : ''); ?>>HS Code Assistance</option>
                                    <option value="Technical Support" <?php echo e(old('subject') == 'Technical Support' ? 'selected' : ''); ?>>Technical Support</option>
                                    <option value="Partnership Inquiry" <?php echo e(old('subject') == 'Partnership Inquiry' ? 'selected' : ''); ?>>Partnership Inquiry</option>
                                    <option value="General Inquiry" <?php echo e(old('subject') == 'General Inquiry' ? 'selected' : ''); ?>>General Inquiry</option>
                                    <option value="Other" <?php echo e(old('subject') == 'Other' ? 'selected' : ''); ?>>Other</option>
                                </select>
                                <?php $__errorArgs = ['subject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-3">
                        <label for="message" class="form-label fw-semibold">Message *</label>
                        <textarea class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  id="message" name="message" rows="5" 
                                  placeholder="Please describe your inquiry in detail..." required><?php echo e(old('message')); ?></textarea>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="newsletter" name="newsletter" value="1" <?php echo e(old('newsletter') ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="newsletter">
                            Subscribe to our newsletter for updates on tax regulations and system features
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitContactForm">
                        <i class="fas fa-paper-plane me-2"></i>Send Message
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Success Modal -->
<div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title" id="successModalLabel">
                    <i class="fas fa-check-circle me-2"></i>Message Sent Successfully
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <div class="mb-4">
                    <i class="fas fa-check-circle text-success" style="font-size: 4rem;"></i>
                </div>
                <h4 class="text-success mb-3">Thank You!</h4>
                <p class="text-muted mb-4">
                    Your message has been received successfully. We've sent a confirmation email to your address. 
                    Our team will get back to you within 24 hours.
                </p>
                <button type="button" class="btn btn-success" data-bs-dismiss="modal">Continue</button>
            </div>
        </div>
    </div>
</div>

<style>
.contact-option:hover {
    transform: translateY(-2px);
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1) !important;
}

.accordion-button:not(.collapsed) {
    background-color: #e3f2fd;
    color: #0d6efd;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Contact form submission
    const contactForm = document.getElementById('contactForm');
    if (contactForm) {
        contactForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const submitBtn = document.getElementById('submitContactForm');
            const originalText = submitBtn.innerHTML;
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Sending...';
            
            // Submit form via AJAX
            fetch(this.action, {
                method: 'POST',
                body: new FormData(this),
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Accept': 'application/json'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    // Close contact form modal
                    const contactModal = bootstrap.Modal.getInstance(document.getElementById('contactFormModal'));
                    contactModal.hide();
                    
                    // Show success modal
                    const successModal = new bootstrap.Modal(document.getElementById('successModal'));
                    successModal.show();
                    
                    // Reset form
                    contactForm.reset();
                } else {
                    alert('There was an error sending your message. Please try again.');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('There was an error sending your message. Please try again.');
            })
            .finally(() => {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            });
        });
    }
});

// WhatsApp function
function openWhatsApp() {
    const whatsappNumber = '<?php echo e(setting("whatsapp_number", "254736857813")); ?>';
    const message = 'Hello <?php echo e(company_name()); ?> Team, I need assistance with import tax calculations.';
    const encodedMessage = encodeURIComponent(message);
    const whatsappUrl = `https://wa.me/${whatsappNumber}?text=${encodedMessage}`;
    window.open(whatsappUrl, '_blank');
}

// Email function
function openEmail() {
    const email = '<?php echo e(setting("contact_email", "dev@eflixdigital.com")); ?>';
    const subject = 'Inquiry - <?php echo e(company_name()); ?>';
    const body = `Hello <?php echo e(company_name()); ?> Team,\n\nI would like to inquire about:\n\n[Please describe your inquiry here]\n\nThank you.`;
    const encodedSubject = encodeURIComponent(subject);
    const encodedBody = encodeURIComponent(body);
    const mailtoUrl = `mailto:${email}?subject=${encodedSubject}&body=${encodedBody}`;
    window.location.href = mailtoUrl;
}

// Contact Form function
function openContactForm() {
    const contactModal = new bootstrap.Modal(document.getElementById('contactFormModal'));
    contactModal.show();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.guest', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/guest/contact.blade.php ENDPATH**/ ?>