

<?php $__env->startSection('title', 'System Health'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-heartbeat me-2"></i>System Health
        </h1>
        <div>
            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#clearCacheModal">
                <i class="fas fa-broom me-2"></i>Clear Cache
            </button>
            <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#backupModal">
                <i class="fas fa-download me-2"></i>Run Backup
            </button>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- System Information -->
    <div class="row mb-4">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-info-circle me-2"></i>System Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>PHP Version</strong></td>
                                    <td><?php echo e($systemInfo['php_version']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Laravel Version</strong></td>
                                    <td><?php echo e($systemInfo['laravel_version']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Server Software</strong></td>
                                    <td><?php echo e($systemInfo['server_software']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Server OS</strong></td>
                                    <td><?php echo e($systemInfo['server_os']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Memory Limit</strong></td>
                                    <td><?php echo e($systemInfo['memory_limit']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Max Execution Time</strong></td>
                                    <td><?php echo e($systemInfo['max_execution_time']); ?> seconds</td>
                                </tr>
                                <tr>
                                    <td><strong>Timezone</strong></td>
                                    <td><?php echo e($systemInfo['timezone']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Environment</strong></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($systemInfo['environment'] === 'production' ? 'success' : 'warning'); ?>">
                                            <?php echo e($systemInfo['environment']); ?>

                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-success text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-database me-2"></i>Database Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>Driver</strong></td>
                                    <td><?php echo e($databaseInfo['driver']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Database</strong></td>
                                    <td><?php echo e($databaseInfo['database']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Connection Status</strong></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($databaseInfo['connection_status'] === 'Connected' ? 'success' : 'danger'); ?>">
                                            <?php echo e($databaseInfo['connection_status']); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Table Count</strong></td>
                                    <td><?php echo e($databaseInfo['table_count']); ?></td>
                                </tr>
                                <?php if(isset($databaseInfo['error'])): ?>
                                <tr>
                                    <td><strong>Error</strong></td>
                                    <td class="text-danger"><?php echo e($databaseInfo['error']); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if(count($databaseInfo['table_sizes']) > 0): ?>
                    <h6 class="mt-4 mb-3">Largest Tables</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-striped">
                            <thead>
                                <tr>
                                    <th>Table</th>
                                    <th>Size</th>
                                    <th>Rows</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = array_slice($databaseInfo['table_sizes'], 0, 5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $table): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($table->table); ?></td>
                                    <td><?php echo e($table->size_mb); ?> MB</td>
                                    <td><?php echo e(number_format($table->rows)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Storage & Cache -->
    <div class="row mb-4">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-hdd me-2"></i>Storage Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>Local Disk Status</strong></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($storageInfo['local_disk_status'] === 'OK' ? 'success' : 'danger'); ?>">
                                            <?php echo e($storageInfo['local_disk_status']); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Public Disk Status</strong></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($storageInfo['public_disk_status'] === 'OK' ? 'success' : 'danger'); ?>">
                                            <?php echo e($storageInfo['public_disk_status']); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Local Disk Free Space</strong></td>
                                    <td><?php echo e($storageInfo['local_disk_free_space']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Public Disk Free Space</strong></td>
                                    <td><?php echo e($storageInfo['public_disk_free_space']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-warning text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-bolt me-2"></i>Cache Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>Cache Driver</strong></td>
                                    <td><?php echo e($cacheInfo['driver']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Cache Status</strong></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($cacheInfo['status'] === 'OK' ? 'success' : 'danger'); ?>">
                                            <?php echo e($cacheInfo['status']); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Cache Prefix</strong></td>
                                    <td><?php echo e($cacheInfo['prefix']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Application Information -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header bg-secondary text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-cube me-2"></i>Application Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Application Name</strong></td>
                                            <td><?php echo e($applicationInfo['name']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Application URL</strong></td>
                                            <td><?php echo e($applicationInfo['url']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Debug Mode</strong></td>
                                            <td>
                                                <span class="badge bg-<?php echo e($applicationInfo['debug'] === 'Enabled' ? 'warning' : 'success'); ?>">
                                                    <?php echo e($applicationInfo['debug']); ?>

                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Maintenance Mode</strong></td>
                                            <td>
                                                <span class="badge bg-<?php echo e($applicationInfo['maintenance_mode'] === 'Enabled' ? 'danger' : 'success'); ?>">
                                                    <?php echo e($applicationInfo['maintenance_mode']); ?>

                                                </span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Last Calculation</strong></td>
                                            <td><?php echo e($applicationInfo['last_calculation']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Calculations</strong></td>
                                            <td><?php echo e(number_format($applicationInfo['total_calculations'])); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Users</strong></td>
                                            <td><?php echo e(number_format($applicationInfo['total_users'])); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Backup Information -->
<!-- Backup Information -->
<div class="row">
    <div class="col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold">
                    <i class="fas fa-download me-2"></i>Backup Information
                </h6>
                <div>
                    <span class="badge bg-light text-dark me-2">
                        <?php echo e($backupInfo['backup_count']); ?> backups
                    </span>
                    <span class="badge bg-light text-dark">
                        Total: <?php echo e($backupInfo['total_backup_size']); ?>

                    </span>
                </div>
            </div>
            <div class="card-body">
                <?php if($backupInfo['backup_count'] > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Backup File</th>
                                <th>Size</th>
                                <th>Modified</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $backupInfo['backups']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <i class="fas fa-file-archive me-2 text-primary"></i>
                                    <?php echo e($backup['name']); ?>

                                </td>
                                <td><?php echo e($backup['size']); ?></td>
                                <td><?php echo e(date('Y-m-d H:i:s', $backup['modified'])); ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?php echo e(route('admin.system-health.download-backup', ['filename' => $backup['name']])); ?>"
                                           class="btn btn-primary" title="Download">
                                            <i class="fas fa-download"></i>
                                        </a>
                                        <button type="button" class="btn btn-danger" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#deleteBackupModal"
                                                data-backup-name="<?php echo e($backup['name']); ?>"
                                                title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center py-4">
                    <i class="fas fa-file-archive fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No backups found</h5>
                    <p class="text-muted">Create your first backup using the button above.</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<!-- Clear Cache Modal -->
<div class="modal fade" id="clearCacheModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Clear Cache</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to clear all cache? This will clear:</p>
                <ul>
                    <li>Application Cache</li>
                    <li>Configuration Cache</li>
                    <li>Route Cache</li>
                    <li>View Cache</li>
                </ul>
                <p class="text-warning"><strong>Note:</strong> This action may temporarily slow down the application.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="<?php echo e(route('admin.system-health.clear-cache')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-warning">Clear Cache</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Backup Modal -->
<div class="modal fade" id="backupModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Run Backup</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to run a system backup? This will backup:</p>
                <ul>
                    <li>Database</li>
                    <li>Application Files</li>
                </ul>
                <p class="text-info"><strong>Note:</strong> Make sure you have the backup package installed (spatie/laravel-backup).</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="<?php echo e(route('admin.system-health.run-backup')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">Run Backup</button>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Delete Backup Modal -->
<div class="modal fade" id="deleteBackupModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Backup</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this backup file?</p>
                <p class="text-danger"><strong>Warning:</strong> This action cannot be undone.</p>
                <p>File: <strong id="backupFileName"></strong></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteBackupForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete Backup</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Delete backup modal handler
    const deleteBackupModal = document.getElementById('deleteBackupModal');
    if (deleteBackupModal) {
        deleteBackupModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            const backupName = button.getAttribute('data-backup-name');
            const form = document.getElementById('deleteBackupForm');
            
            document.getElementById('backupFileName').textContent = backupName;
            
            // Fix: Use proper route construction
            const baseUrl = "<?php echo e(route('admin.system-health.delete-backup', ['filename' => 'PLACEHOLDER'])); ?>";
            form.action = baseUrl.replace('PLACEHOLDER', encodeURIComponent(backupName));
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/admin/system-health/index.blade.php ENDPATH**/ ?>