

<?php $__env->startSection('title', 'Country Duty Overrides'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Country Duty Overrides</h2>
                <a href="<?php echo e(route('admin.country-overrides.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Override
                </a>
            </div>
            <p class="text-muted">Manage country-specific duty rates for HS codes</p>
        </div>
    </div>
</div>

<?php echo $__env->make('partials.admin.alerts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Search and Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form action="<?php echo e(route('admin.country-overrides.index')); ?>" method="GET">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="search">Search HS Code, Description or Country</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="<?php echo e(request('search')); ?>" placeholder="Search...">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="country_code">Country</label>
                        <select class="form-control" id="country_code" name="country_code">
                            <option value="">All Countries</option>
                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($country->code); ?>" <?php echo e(request('country_code') == $country->code ? 'selected' : ''); ?>>
                                    <?php echo e($country->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="duty_type">Duty Type</label>
                        <select class="form-control" id="duty_type" name="duty_type">
                            <option value="">All Types</option>
                            <option value="percentage" <?php echo e(request('duty_type') == 'percentage' ? 'selected' : ''); ?>>Percentage</option>
                            <option value="flat" <?php echo e(request('duty_type') == 'flat' ? 'selected' : ''); ?>>Flat Rate</option>
                            <option value="per_kg" <?php echo e(request('duty_type') == 'per_kg' ? 'selected' : ''); ?>>Per KG</option>
                            <option value="per_container" <?php echo e(request('duty_type') == 'per_container' ? 'selected' : ''); ?>>Per Container</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Country Overrides Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">Country Duty Overrides</h4>
        <a href="<?php echo e(route('admin.country-overrides.create')); ?>" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add New
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Country</th>
                        <th>HS Code</th>
                        <th>Description</th>
                        <th>Duty Type</th>
                        <th>Duty Value</th>
                        <th>Effective Period</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $overrides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $override): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <strong><?php echo e($override->country->code); ?></strong>
                            <br>
                            <small class="text-muted"><?php echo e($override->country->name); ?></small>
                            <?php if($override->country->region): ?>
                                <br>
                                <span class="badge bg-info"><?php echo e($override->country->region); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <strong><?php echo e($override->hsCode->hs_code); ?></strong>
                        </td>
                        <td>
                            <span title="<?php echo e($override->hsCode->description); ?>">
                                <?php echo e(Str::limit($override->hsCode->description, 40)); ?>

                            </span>
                        </td>
                        <td>
                            <span class="badge bg-info text-capitalize"><?php echo e($override->duty_type); ?></span>
                        </td>
                        <td>
                            <?php if($override->duty_type === 'percentage'): ?>
                                <?php echo e($override->duty_value); ?>%
                            <?php else: ?>
                                <?php echo e(number_format($override->duty_value, 2)); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <small>
                                <?php echo e($override->effective_from->format('M j, Y')); ?>

                                <?php if($override->effective_to): ?>
                                    <br>to <?php echo e($override->effective_to->format('M j, Y')); ?>

                                <?php else: ?>
                                    <br><span class="text-success">Ongoing</span>
                                <?php endif; ?>
                            </small>
                        </td>
                        <td>
                            <?php if($override->is_active): ?>
                                <span class="badge bg-success">Active</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="<?php echo e(route('admin.country-overrides.show', $override->id)); ?>" class="btn btn-info btn-sm" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.country-overrides.edit', $override->id)); ?>" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="<?php echo e(route('admin.country-overrides.clone', $override->id)); ?>" class="btn btn-secondary btn-sm" title="Clone">
                                    <i class="fas fa-copy"></i>
                                </a>
                                <form action="<?php echo e(route('admin.country-overrides.destroy', $override->id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm" title="Delete" onclick="return confirm('Are you sure you want to delete this override?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <?php if($overrides->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($overrides->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/admin/country-overrides/index.blade.php ENDPATH**/ ?>