

<?php $__env->startSection('title', 'API Documentation'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-code me-2"></i>API Documentation
        </h1>
        <div>
            <a href="<?php echo e(route('admin.api-docs.export')); ?>" class="btn btn-success btn-sm">
                <i class="fas fa-download me-2"></i>Export Postman Collection
            </a>
        </div>
    </div>

    <!-- Quick Start -->
    <div class="card shadow mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">
                <i class="fas fa-rocket me-2"></i>Quick Start
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6>Base URL</h6>
                    <code class="bg-light p-2 rounded d-block"><?php echo e(url('/api/v1')); ?></code>
                    
                    <h6 class="mt-3">Authentication</h6>
                    <p>Most endpoints require API key authentication:</p>
                    <code class="bg-light p-2 rounded d-block">Authorization: Bearer YOUR_API_KEY</code>
                </div>
                <div class="col-md-6">
                    <h6>Response Format</h6>
                    <pre class="bg-light p-3 rounded"><code>{
    "success": true,
    "data": { ... },
    "message": "Operation successful"
}</code></pre>
                    
                    <h6>Error Format</h6>
                    <pre class="bg-light p-3 rounded"><code>{
    "success": false,
    "error": "Error message",
    "code": 400
}</code></pre>
                </div>
            </div>
        </div>
    </div>

    <!-- Tax Calculation API -->
    <div class="card shadow mb-4">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0">
                <i class="fas fa-calculator me-2"></i>Tax Calculation API
            </h5>
        </div>
        <div class="card-body">
            <div class="mb-4">
                <span class="badge bg-success me-2">GET</span>
                <code class="h5">/api/v1/tax-calculate</code>
                <span class="badge bg-info ms-2">Public</span>
            </div>

            <h6>Description</h6>
            <p>Calculate import taxes for goods based on HS code, value, and other parameters.</p>

            <h6>Parameters</h6>
            <div class="table-responsive">
                <table class="table table-bordered table-sm">
                    <thead class="table-light">
                        <tr>
                            <th>Parameter</th>
                            <th>Type</th>
                            <th>Required</th>
                            <th>Description</th>
                            <th>Example</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>hs_code</code></td>
                            <td>string</td>
                            <td><span class="badge bg-success">Yes</span></td>
                            <td>HS Code of the product</td>
                            <td>870321</td>
                        </tr>
                        <tr>
                            <td><code>cif_value</code></td>
                            <td>number</td>
                            <td><span class="badge bg-success">Yes</span></td>
                            <td>CIF value in KES</td>
                            <td>1500000</td>
                        </tr>
                        <tr>
                            <td><code>country_of_origin</code></td>
                            <td>string</td>
                            <td><span class="badge bg-success">Yes</span></td>
                            <td>ISO country code</td>
                            <td>CN</td>
                        </tr>
                        <tr>
                            <td><code>weight_kg</code></td>
                            <td>number</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Weight in kilograms</td>
                            <td>1500</td>
                        </tr>
                        <tr>
                            <td><code>description</code></td>
                            <td>string</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Product description</td>
                            <td>Passenger vehicles</td>
                        </tr>
                        <tr>
                            <td><code>currency</code></td>
                            <td>string</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Currency code (default: KES)</td>
                            <td>USD</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <h6>Example Request</h6>
            <div class="bg-dark text-light p-3 rounded mb-3">
                <pre class="mb-0"><code>GET <?php echo e(url('/api/v1/tax-calculate')); ?>?hs_code=870321&cif_value=1500000&country_of_origin=CN&weight_kg=1500</code></pre>
            </div>

            <h6>Example Response</h6>
            <div class="bg-dark text-light p-3 rounded">
                <pre class="mb-0"><code>{
    "success": true,
    "data": {
        "calculation_id": "calc_123456",
        "hs_code": "870321",
        "description": "Passenger motor vehicles",
        "cif_value": 1500000,
        "country_of_origin": "CN",
        "tax_breakdown": {
            "import_duty": {
                "rate": 25,
                "amount": 375000,
                "type": "percentage"
            },
            "vat": {
                "rate": 16,
                "amount": 300000,
                "base": 1875000
            },
            "excise_duty": {
                "rate": 20,
                "amount": 375000,
                "applicable": true
            }
        },
        "total_taxes": 1050000,
        "total_payable": 2550000,
        "calculation_steps": [...],
        "timestamp": "2024-01-15T10:30:00Z"
    },
    "message": "Tax calculation completed successfully"
}</code></pre>
            </div>
        </div>
    </div>

    <!-- HS Codes API -->
    <div class="card shadow mb-4">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0">
                <i class="fas fa-search me-2"></i>HS Codes API
            </h5>
        </div>
        <div class="card-body">
            <!-- Get All HS Codes -->
            <div class="mb-5">
                <div class="mb-3">
                    <span class="badge bg-primary me-2">GET</span>
                    <code class="h6">/api/v1/hs-codes</code>
                    <span class="badge bg-info ms-2">Public</span>
                </div>
                <p>Retrieve all HS codes with their tax configurations.</p>

                <h6>Parameters</h6>
                <table class="table table-bordered table-sm">
                    <thead class="table-light">
                        <tr>
                            <th>Parameter</th>
                            <th>Type</th>
                            <th>Required</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>search</code></td>
                            <td>string</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Search by HS code or description</td>
                        </tr>
                        <tr>
                            <td><code>page</code></td>
                            <td>integer</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Page number for pagination</td>
                        </tr>
                        <tr>
                            <td><code>per_page</code></td>
                            <td>integer</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Items per page (default: 20)</td>
                        </tr>
                    </tbody>
                </table>

                <h6>Example Response</h6>
                <div class="bg-dark text-light p-3 rounded">
                    <pre class="mb-0"><code>{
    "success": true,
    "data": {
        "data": [
            {
                "hs_code": "870321",
                "description": "Passenger motor vehicles",
                "default_duty_type": "percentage",
                "default_duty_value": 25,
                "excise_applicable": true,
                "sensitive": false
            }
        ],
        "current_page": 1,
        "total": 1500
    }
}</code></pre>
                </div>
            </div>

            <!-- Get Single HS Code -->
            <div>
                <div class="mb-3">
                    <span class="badge bg-primary me-2">GET</span>
                    <code class="h6">/api/v1/hs-codes/{code}</code>
                    <span class="badge bg-info ms-2">Public</span>
                </div>
                <p>Retrieve detailed information for a specific HS code.</p>

                <h6>Example Request</h6>
                <div class="bg-dark text-light p-3 rounded mb-3">
                    <pre class="mb-0"><code>GET <?php echo e(url('/api/v1/hs-codes/870321')); ?></code></pre>
                </div>

                <h6>Example Response</h6>
                <div class="bg-dark text-light p-3 rounded">
                    <pre class="mb-0"><code>{
    "success": true,
    "data": {
        "hs_code": "870321",
        "description": "Passenger motor vehicles with spark-ignition engine",
        "default_duty_type": "percentage",
        "default_duty_value": 25,
        "excise_applicable": true,
        "excise_formula": {
            "rate": 20,
            "minimum": 0
        },
        "sensitive": false,
        "created_at": "2024-01-01T00:00:00Z",
        "updated_at": "2024-01-01T00:00:00Z",
        "benchmarks": [...],
        "country_overrides": [...]
    }
}</code></pre>
                </div>
            </div>
        </div>
    </div>

    <!-- Reference Data APIs -->
    <div class="card shadow mb-4">
        <div class="card-header bg-warning text-white">
            <h5 class="mb-0">
                <i class="fas fa-database me-2"></i>Reference Data APIs
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Countries API -->
                <div class="col-md-6 mb-4">
                    <div class="mb-3">
                        <span class="badge bg-primary me-2">GET</span>
                        <code class="h6">/api/v1/countries</code>
                        <span class="badge bg-info ms-2">Public</span>
                    </div>
                    <p>Get list of supported countries with their codes and trade agreements.</p>
                    
                    <h6>Example Response</h6>
                    <div class="bg-dark text-light p-3 rounded">
                        <pre class="mb-0"><code>{
    "success": true,
    "data": [
        {
            "code": "CN",
            "name": "China",
            "region": "Asia",
            "trade_agreement": "none"
        }
    ]
}</code></pre>
                    </div>
                </div>

                <!-- Currencies API -->
                <div class="col-md-6 mb-4">
                    <div class="mb-3">
                        <span class="badge bg-primary me-2">GET</span>
                        <code class="h6">/api/v1/currencies</code>
                        <span class="badge bg-info ms-2">Public</span>
                    </div>
                    <p>Get supported currencies and their current exchange rates.</p>
                    
                    <h6>Example Response</h6>
                    <div class="bg-dark text-light p-3 rounded">
                        <pre class="mb-0"><code>{
    "success": true,
    "data": [
        {
            "code": "USD",
            "name": "US Dollar",
            "exchange_rate": 157.50,
            "updated_at": "2024-01-15T10:00:00Z"
        }
    ]
}</code></pre>
                    </div>
                </div>

                <!-- Exchange Rates API -->
                <div class="col-md-6">
                    <div class="mb-3">
                        <span class="badge bg-primary me-2">GET</span>
                        <code class="h6">/api/v1/exchange-rates</code>
                        <span class="badge bg-info ms-2">Public</span>
                    </div>
                    <p>Get current exchange rates against KES.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Authenticated APIs -->
    <div class="card shadow mb-4">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0">
                <i class="fas fa-lock me-2"></i>Authenticated APIs
            </h5>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <i class="fas fa-info-circle me-2"></i>
                These endpoints require API key authentication. Contact administrators to get your API key.
            </div>

            <!-- Bulk Calculation -->
            <div class="mb-5">
                <div class="mb-3">
                    <span class="badge bg-success me-2">POST</span>
                    <code class="h6">/api/v1/bulk-calculate</code>
                    <span class="badge bg-danger ms-2">Authenticated</span>
                </div>
                <p>Perform multiple tax calculations in a single request.</p>

                <h6>Request Body</h6>
                <div class="bg-dark text-light p-3 rounded mb-3">
                    <pre class="mb-0"><code>{
    "calculations": [
        {
            "hs_code": "870321",
            "cif_value": 1500000,
            "country_of_origin": "CN",
            "weight_kg": 1500
        },
        {
            "hs_code": "030211",
            "cif_value": 500000,
            "country_of_origin": "JP",
            "weight_kg": 1000
        }
    ]
}</code></pre>
                </div>

                <h6>Headers</h6>
                <code class="bg-light p-2 rounded d-block mb-3">Authorization: Bearer your_api_key_here</code>
            </div>

            <!-- Calculation History -->
            <div>
                <div class="mb-3">
                    <span class="badge bg-primary me-2">GET</span>
                    <code class="h6">/api/v1/calculation-history</code>
                    <span class="badge bg-danger ms-2">Authenticated</span>
                </div>
                <p>Retrieve calculation history for your account.</p>

                <h6>Parameters</h6>
                <table class="table table-bordered table-sm">
                    <thead class="table-light">
                        <tr>
                            <th>Parameter</th>
                            <th>Type</th>
                            <th>Required</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>date_from</code></td>
                            <td>string</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Filter from date (YYYY-MM-DD)</td>
                        </tr>
                        <tr>
                            <td><code>date_to</code></td>
                            <td>string</td>
                            <td><span class="badge bg-warning">Optional</span></td>
                            <td>Filter to date (YYYY-MM-DD)</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Error Codes -->
    <div class="card shadow mb-4">
        <div class="card-header bg-secondary text-white">
            <h5 class="mb-0">
                <i class="fas fa-exclamation-triangle me-2"></i>Error Codes
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th>Code</th>
                            <th>Message</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><span class="badge bg-danger">400</span></td>
                            <td>Bad Request</td>
                            <td>Invalid parameters or missing required fields</td>
                        </tr>
                        <tr>
                            <td><span class="badge bg-danger">401</span></td>
                            <td>Unauthorized</td>
                            <td>Missing or invalid API key</td>
                        </tr>
                        <tr>
                            <td><span class="badge bg-danger">403</span></td>
                            <td>Forbidden</td>
                            <td>API key doesn't have permission for this endpoint</td>
                        </tr>
                        <tr>
                            <td><span class="badge bg-danger">404</span></td>
                            <td>Not Found</td>
                            <td>HS code or resource not found</td>
                        </tr>
                        <tr>
                            <td><span class="badge bg-danger">422</span></td>
                            <td>Unprocessable Entity</td>
                            <td>Validation errors in request data</td>
                        </tr>
                        <tr>
                            <td><span class="badge bg-danger">429</span></td>
                            <td>Too Many Requests</td>
                            <td>Rate limit exceeded</td>
                        </tr>
                        <tr>
                            <td><span class="badge bg-danger">500</span></td>
                            <td>Internal Server Error</td>
                            <td>Server-side error</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Rate Limiting -->
    <div class="card shadow">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0">
                <i class="fas fa-tachometer-alt me-2"></i>Rate Limiting
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6>Public Endpoints</h6>
                    <ul>
                        <li><strong>60 requests per minute</strong> per IP address</li>
                        <li>Applies to tax calculation and data lookup endpoints</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <h6>Authenticated Endpoints</h6>
                    <ul>
                        <li><strong>1000 requests per hour</strong> per API key</li>
                        <li>Higher limits available for enterprise plans</li>
                    </ul>
                </div>
            </div>
            
            <div class="alert alert-warning mt-3">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Exceeding rate limits will result in <code>429 Too Many Requests</code> responses.
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
pre {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 4px;
    padding: 1rem;
    overflow-x: auto;
}

code {
    color: #e83e8c;
    background: #f8f9fa;
    padding: 0.2rem 0.4rem;
    border-radius: 3px;
}

.bg-dark pre {
    background: #2d3748;
    border-color: #4a5568;
}

.bg-dark code {
    background: #4a5568;
    color: #fff;
}

.table th {
    border-top: none;
    font-weight: 600;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tax-simulator\resources\views/admin/api-docs.blade.php ENDPATH**/ ?>