<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="tax_name" class="form-label">Tax Name *</label>
            <select class="form-control @error('tax_name') is-invalid @enderror" 
                    id="tax_name" name="tax_name" required>
                <option value="">Select Tax Type</option>
                <option value="VAT" {{ (old('tax_name', $taxConfig->tax_name ?? '') == 'VAT') ? 'selected' : '' }}>VAT</option>
                <option value="IDF" {{ (old('tax_name', $taxConfig->tax_name ?? '') == 'IDF') ? 'selected' : '' }}>IDF</option>
                <option value="RDL" {{ (old('tax_name', $taxConfig->tax_name ?? '') == 'RDL') ? 'selected' : '' }}>RDL</option>
                <option value="Excise" {{ (old('tax_name', $taxConfig->tax_name ?? '') == 'Excise') ? 'selected' : '' }}>Excise</option>
            </select>
            @error('tax_name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="rate_type" class="form-label">Rate Type *</label>
            <select class="form-control @error('rate_type') is-invalid @enderror" 
                    id="rate_type" name="rate_type" required>
                <option value="">Select Rate Type</option>
                <option value="percentage" {{ (old('rate_type', $taxConfig->rate_type ?? '') == 'percentage') ? 'selected' : '' }}>Percentage</option>
                <option value="flat" {{ (old('rate_type', $taxConfig->rate_type ?? '') == 'flat') ? 'selected' : '' }}>Flat Rate</option>
            </select>
            @error('rate_type')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="rate" class="form-label">Rate Value *</label>
            <input type="number" step="0.0001" class="form-control @error('rate') is-invalid @enderror" 
                   id="rate" name="rate" value="{{ old('rate', $taxConfig->rate ?? '') }}" required>
            @error('rate')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="min_amount" class="form-label">Minimum Amount</label>
            <input type="number" step="0.01" class="form-control @error('min_amount') is-invalid @enderror" 
                   id="min_amount" name="min_amount" value="{{ old('min_amount', $taxConfig->min_amount ?? '') }}">
            @error('min_amount')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="effective_from" class="form-label">Effective From *</label>
            <input type="date" class="form-control @error('effective_from') is-invalid @enderror" 
                   id="effective_from" name="effective_from" 
                   value="{{ old('effective_from', $taxConfig->effective_from ?? '') }}" required>
            @error('effective_from')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="effective_to" class="form-label">Effective To</label>
            <input type="date" class="form-control @error('effective_to') is-invalid @enderror" 
                   id="effective_to" name="effective_to" 
                   value="{{ old('effective_to', $taxConfig->effective_to ?? '') }}">
            @error('effective_to')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
            <small class="form-text text-muted">Leave empty if currently active</small>
        </div>
    </div>
</div>

<div class="form-group">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" id="active" name="active" 
               value="1" {{ (old('active', $taxConfig->active ?? true)) ? 'checked' : '' }}>
        <label class="form-check-label" for="active">Active</label>
    </div>
</div>