<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="hs_code" class="form-label">HS Code *</label>
            <input type="text" class="form-control @error('hs_code') is-invalid @enderror" 
                   id="hs_code" name="hs_code" value="{{ old('hs_code', $calculation->hs_code ?? '') }}" 
                   placeholder="e.g., 870321" required>
            @error('hs_code')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="country_of_origin" class="form-label">Country of Origin *</label>
            <select class="form-control @error('country_of_origin') is-invalid @enderror" 
                    id="country_of_origin" name="country_of_origin" required>
                <option value="">Select Country</option>
                @foreach($countries as $country)
                    <option value="{{ $country->code }}" 
                        {{ (old('country_of_origin', $calculation->country_of_origin ?? '') == $country->code) ? 'selected' : '' }}>
                        {{ $country->code }} - {{ $country->name }}
                    </option>
                @endforeach
            </select>
            @error('country_of_origin')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="customs_value" class="form-label">Customs Value (FOB) *</label>
            <input type="number" step="0.01" class="form-control @error('customs_value') is-invalid @enderror" 
                   id="customs_value" name="customs_value" 
                   value="{{ old('customs_value', $calculation->customs_value ?? '') }}" required>
            @error('customs_value')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="freight" class="form-label">Freight Cost</label>
            <input type="number" step="0.01" class="form-control @error('freight') is-invalid @enderror" 
                   id="freight" name="freight" value="{{ old('freight', $calculation->freight ?? 0) }}">
            @error('freight')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="insurance" class="form-label">Insurance Cost</label>
            <input type="number" step="0.01" class="form-control @error('insurance') is-invalid @enderror" 
                   id="insurance" name="insurance" value="{{ old('insurance', $calculation->insurance ?? 0) }}">
            @error('insurance')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="currency" class="form-label">Currency *</label>
            <select class="form-control @error('currency') is-invalid @enderror" 
                    id="currency" name="currency" required>
                <option value="">Select Currency</option>
                @foreach($currencies as $currency)
                    <option value="{{ $currency->code }}" 
                        {{ (old('currency', $calculation->currency ?? 'USD') == $currency->code) ? 'selected' : '' }}>
                        {{ $currency->code }}
                    </option>
                @endforeach
            </select>
            @error('currency')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="weight_kg" class="form-label">Weight (KG)</label>
            <input type="number" step="0.01" class="form-control @error('weight_kg') is-invalid @enderror" 
                   id="weight_kg" name="weight_kg" value="{{ old('weight_kg', $calculation->weight_kg ?? '') }}">
            @error('weight_kg')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="container_type" class="form-label">Container Type</label>
            <select class="form-control @error('container_type') is-invalid @enderror" 
                    id="container_type" name="container_type">
                <option value="">Select Container</option>
                <option value="20ft" {{ (old('container_type', $calculation->container_type ?? '') == '20ft') ? 'selected' : '' }}>20ft Container</option>
                <option value="40ft" {{ (old('container_type', $calculation->container_type ?? '') == '40ft') ? 'selected' : '' }}>40ft Container</option>
            </select>
            @error('container_type')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="form-group">
    <label for="product_description" class="form-label">Product Description</label>
    <textarea class="form-control @error('product_description') is-invalid @enderror" 
              id="product_description" name="product_description" rows="2">{{ old('product_description', $calculation->product_description ?? '') }}</textarea>
    @error('product_description')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>