<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="hs_code" class="form-label">HS Code *</label>
            <input type="text" class="form-control @error('hs_code') is-invalid @enderror" 
                   id="hs_code" name="hs_code" value="{{ old('hs_code', $hsCode->hs_code ?? '') }}" 
                   placeholder="e.g., 870321" required>
            @error('hs_code')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="description" class="form-label">Description *</label>
            <input type="text" class="form-control @error('description') is-invalid @enderror" 
                   id="description" name="description" value="{{ old('description', $hsCode->description ?? '') }}"
                   placeholder="e.g., Motor cars for transport of persons" required>
            @error('description')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="default_duty_type" class="form-label">Default Duty Type *</label>
            <select class="form-control @error('default_duty_type') is-invalid @enderror" 
                    id="default_duty_type" name="default_duty_type" required>
                <option value="">Select Duty Type</option>
                <option value="percentage" {{ (old('default_duty_type', $hsCode->default_duty_type ?? '') == 'percentage') ? 'selected' : '' }}>Percentage</option>
                <option value="flat" {{ (old('default_duty_type', $hsCode->default_duty_type ?? '') == 'flat') ? 'selected' : '' }}>Flat Rate</option>
                <option value="per_kg" {{ (old('default_duty_type', $hsCode->default_duty_type ?? '') == 'per_kg') ? 'selected' : '' }}>Per KG</option>
                <option value="per_container" {{ (old('default_duty_type', $hsCode->default_duty_type ?? '') == 'per_container') ? 'selected' : '' }}>Per Container</option>
            </select>
            @error('default_duty_type')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="default_duty_value" class="form-label">Default Duty Value *</label>
            <input type="number" step="0.0001" class="form-control @error('default_duty_value') is-invalid @enderror" 
                   id="default_duty_value" name="default_duty_value" 
                   value="{{ old('default_duty_value', $hsCode->default_duty_value ?? '') }}" required>
            @error('default_duty_value')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="sensitive" class="form-label">Sensitive Goods</label>
            <div class="form-check mt-2">
                <input type="checkbox" class="form-check-input" id="sensitive" name="sensitive" 
                       value="1" {{ (old('sensitive', $hsCode->sensitive ?? false)) ? 'checked' : '' }}>
                <label class="form-check-label" for="sensitive">Mark as sensitive</label>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="excise_applicable" class="form-label">Excise Applicable</label>
            <div class="form-check mt-2">
                <input type="checkbox" class="form-check-input" id="excise_applicable" name="excise_applicable" 
                       value="1" {{ (old('excise_applicable', $hsCode->excise_applicable ?? false)) ? 'checked' : '' }}>
                <label class="form-check-label" for="excise_applicable">Apply Excise Duty</label>
            </div>
        </div>
    </div>
</div>

<div class="row" id="excise_formula_section" style="{{ (old('excise_applicable', $hsCode->excise_applicable ?? false)) ? '' : 'display: none;' }}">
    <div class="col-12">
        <div class="form-group">
            <label for="excise_formula" class="form-label">Excise Formula (JSON)</label>
            <textarea class="form-control @error('excise_formula') is-invalid @enderror" 
                      id="excise_formula" name="excise_formula" rows="4" 
                      placeholder='{"type": "percentage", "value": 10}'>{{ old('excise_formula', $hsCode->excise_formula ?? '') }}</textarea>
            @error('excise_formula')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
            <small class="form-text text-muted">
                JSON format for excise calculation. Example: {"type": "percentage", "value": 10} or {"type": "fixed", "value": 5000}
            </small>
        </div>
    </div>
</div>

<script>
document.getElementById('excise_applicable').addEventListener('change', function() {
    document.getElementById('excise_formula_section').style.display = this.checked ? 'block' : 'none';
});
</script>