<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <label for="base_currency" class="form-label">Base Currency *</label>
            <select class="form-control @error('base_currency') is-invalid @enderror" 
                    id="base_currency" name="base_currency" required>
                <option value="">Select Base Currency</option>
                @foreach($currencies as $currency)
                    <option value="{{ $currency->code }}" 
                        {{ (old('base_currency', $rate->base_currency ?? 'KES') == $currency->code) ? 'selected' : '' }}>
                        {{ $currency->code }}
                    </option>
                @endforeach
            </select>
            @error('base_currency')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="target_currency" class="form-label">Target Currency *</label>
            <select class="form-control @error('target_currency') is-invalid @enderror" 
                    id="target_currency" name="target_currency" required>
                <option value="">Select Target Currency</option>
                @foreach($currencies as $currency)
                    <option value="{{ $currency->code }}" 
                        {{ (old('target_currency', $rate->target_currency ?? '') == $currency->code) ? 'selected' : '' }}>
                        {{ $currency->code }}
                    </option>
                @endforeach
            </select>
            @error('target_currency')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <label for="rate" class="form-label">Exchange Rate *</label>
            <input type="number" step="0.000001" class="form-control @error('rate') is-invalid @enderror" 
                   id="rate" name="rate" value="{{ old('rate', $rate->rate ?? '') }}" required>
            @error('rate')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="effective_date" class="form-label">Effective Date *</label>
            <input type="date" class="form-control @error('effective_date') is-invalid @enderror" 
                   id="effective_date" name="effective_date" 
                   value="{{ old('effective_date', $rate->effective_date ?? '') }}" required>
            @error('effective_date')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>