<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="hs_code_id" class="form-label">HS Code *</label>
            <select class="form-control @error('hs_code_id') is-invalid @enderror" 
                    id="hs_code_id" name="hs_code_id" required>
                <option value="">Select HS Code</option>
                @foreach($hsCodes as $hs)
                    <option value="{{ $hs->id }}" 
                        {{ (old('hs_code_id', $benchmark->hs_code_id ?? '') == $hs->id) ? 'selected' : '' }}>
                        {{ $hs->hs_code }} - {{ $hs->description }}
                    </option>
                @endforeach
            </select>
            @error('hs_code_id')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="min_type" class="form-label">Minimum Type *</label>
            <select class="form-control @error('min_type') is-invalid @enderror" 
                    id="min_type" name="min_type" required>
                <option value="">Select Type</option>
                <option value="cif" {{ (old('min_type', $benchmark->min_type ?? '') == 'cif') ? 'selected' : '' }}>CIF Value</option>
                <option value="per_kg" {{ (old('min_type', $benchmark->min_type ?? '') == 'per_kg') ? 'selected' : '' }}>Per KG</option>
                <option value="per_container" {{ (old('min_type', $benchmark->min_type ?? '') == 'per_container') ? 'selected' : '' }}>Per Container</option>
            </select>
            @error('min_type')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="min_value" class="form-label">Minimum Value *</label>
            <input type="number" step="0.01" class="form-control @error('min_value') is-invalid @enderror" 
                   id="min_value" name="min_value" value="{{ old('min_value', $benchmark->min_value ?? '') }}" required>
            @error('min_value')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="currency" class="form-label">Currency *</label>
            <select class="form-control @error('currency') is-invalid @enderror" 
                    id="currency" name="currency" required>
                <option value="">Select Currency</option>
                @foreach($currencies as $currency)
                    <option value="{{ $currency->code }}" 
                        {{ (old('currency', $benchmark->currency ?? 'KES') == $currency->code) ? 'selected' : '' }}>
                        {{ $currency->code }} - {{ $currency->name }}
                    </option>
                @endforeach
            </select>
            @error('currency')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label for="effective_from" class="form-label">Effective From *</label>
            <input type="date" class="form-control @error('effective_from') is-invalid @enderror" 
                   id="effective_from" name="effective_from" 
                   value="{{ old('effective_from', $benchmark->effective_from ?? '') }}" required>
            @error('effective_from')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label for="effective_to" class="form-label">Effective To</label>
            <input type="date" class="form-control @error('effective_to') is-invalid @enderror" 
                   id="effective_to" name="effective_to" 
                   value="{{ old('effective_to', $benchmark->effective_to ?? '') }}">
            @error('effective_to')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>