<div class="card">
    <div class="card-header bg-{{ $color ?? 'primary' }} text-white">
        <h4 class="mb-0">{{ $title }}</h4>
    </div>
    <div class="card-body">
        <form action="{{ $action }}" method="POST" {{ isset($enctype) ? 'enctype="multipart/form-data"' : '' }}>
            @csrf
            @if(isset($method) && in_array($method, ['PUT', 'PATCH', 'DELETE']))
                @method($method)
            @endif
            
            {{ $slot }}
            
            <div class="form-group mt-4">
                <button type="submit" class="btn btn-{{ $color ?? 'primary' }} me-2">
                    <i class="fas fa-save me-1"></i>{{ $submitText ?? 'Save' }}
                </button>
                <a href="{{ $cancelUrl ?? url()->previous() }}" class="btn btn-secondary">
                    <i class="fas fa-times me-1"></i>Cancel
                </a>
            </div>
        </form>
    </div>
</div>