<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'Admin Dashboard')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap & Theme -->
    <link href="{{ asset('assets/css/styles.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/icons/tabler-icons/tabler-icons.css') }}" rel="stylesheet">

    <style>
        /* === BASE LAYOUT === */
        .page-wrapper {
            transition: margin-left 0.3s;
            margin-left: 250px; /* sidebar visible */
        }
        .left-sidebar {
            width: 250px;
            transition: all 0.3s ease;
            position: fixed;
            top: 0; bottom: 0; left: 0;
            background: #fff;
            z-index: 1000;
            box-shadow: 2px 0 5px rgba(0,0,0,0.05);
            overflow-y: auto;
        }

        /* === DESKTOP HIDDEN MODE === */
        #main-wrapper[data-sidebartype="hidden-sidebar"] .left-sidebar {
            transform: translateX(-100%);
        }
        #main-wrapper[data-sidebartype="hidden-sidebar"] .page-wrapper {
            margin-left: 0 !important;
        }

        /* === MOBILE MODE === */
        @media (max-width: 991px) {
            .left-sidebar {
                transform: translateX(-100%);
                width: 250px !important;
            }
            #main-wrapper.show-sidebar .left-sidebar {
                transform: translateX(0);
            }
            .page-wrapper {
                margin-left: 0 !important; /* always full width */
            }
        }
    </style>
</head>
<body>
    <!-- Main wrapper -->
    <div id="main-wrapper" 
         data-layout="vertical" 
         data-navbarbg="skin6" 
         data-sidebartype="full" 
         data-sidebar-position="fixed" 
         data-header-position="fixed">

        <!-- Topbar -->
        @include('partials.admin.topbar')

        <!-- Sidebar -->
        @include('partials.admin.sidebar')

        <!-- Page wrapper -->
        <div class="page-wrapper">
            <div class="container-fluid py-3">
                @include('partials.admin.alerts')
                @yield('content')
            </div>

            <!-- Footer -->
            <footer class="footer text-center">
                © {{ date('Y') }} Kenya Tax Simulator Admin
            </footer>
        </div>
    </div>

    <!-- Scripts -->
    <script src="{{ asset('assets/js/app.min.js') }}"></script>
    <script src="{{ asset('assets/js/sidebarmenu.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
    document.addEventListener("DOMContentLoaded", function () {
        const toggleBtn = document.getElementById("sidebarToggle");
        const mainWrapper = document.getElementById("main-wrapper");

        // Restore sidebar state on desktop
        const savedState = localStorage.getItem("sidebarState") || "full";
        mainWrapper.setAttribute("data-sidebartype", savedState);

        function toggleSidebar() {
            if (window.innerWidth <= 991) {
                // Mobile → slide
                mainWrapper.classList.toggle("show-sidebar");
            } else {
                // Desktop → full vs hidden
                if (mainWrapper.getAttribute("data-sidebartype") === "full") {
                    mainWrapper.setAttribute("data-sidebartype", "hidden-sidebar");
                    localStorage.setItem("sidebarState", "hidden-sidebar");
                } else {
                    mainWrapper.setAttribute("data-sidebartype", "full");
                    localStorage.setItem("sidebarState", "full");
                }
            }
        }

        if (toggleBtn) toggleBtn.addEventListener("click", toggleSidebar);

        // Adjust on resize
        window.addEventListener("resize", function () {
            if (window.innerWidth > 991) {
                // Desktop → restore saved state
                const saved = localStorage.getItem("sidebarState") || "full";
                mainWrapper.setAttribute("data-sidebartype", saved);
                mainWrapper.classList.remove("show-sidebar");
            } else {
                // Mobile → hide by default
                mainWrapper.classList.remove("show-sidebar");
            }
        });
    });
    </script>
</body>
</html>
