<x-mail::layout>
    <x-slot name="header">
        <x-mail::header :url="config('app.url')">
            Kenya Import Tax Simulator
        </x-mail::header>
    </x-slot>

    # Thank You for Contacting Us!

    Dear {{ $submission->name }},

    We have received your contact form submission and appreciate you reaching out to us. Here's a summary of your inquiry:

    **Subject:** {{ $submission->subject }}  
    **Message:**  
    {{ $submission->message }}

    Our team will review your inquiry and get back to you within 24 hours during our business hours.

    <x-mail::panel>
        **Our Contact Information:**  
        Email: {{ $settings['support_email'] }}  
        WhatsApp: {{ $settings['whatsapp_number'] }}  
        Business Hours: Mon-Fri 8AM-5PM, Sat 9AM-1PM EAT
    </x-mail::panel>

    **Reference Number:** #CS{{ $submission->id }}{{ $submission->created_at->format('Ymd') }}

    If you have any urgent inquiries, feel free to contact us directly via WhatsApp for immediate assistance.

    <x-mail::button :url="'https://wa.me/' . $settings['whatsapp_number']">
        Chat on WhatsApp
    </x-mail::button>

    Best regards,  
    **The Kenya Import Tax Simulator Team**

    <x-slot name="footer">
        <x-mail::footer>
            © {{ date('Y') }} Kenya Import Tax Simulator. All rights reserved.
        </x-mail::footer>
    </x-slot>
</x-mail::layout>