@extends('layouts.guest')

@section('title', 'Tax Calculation Results')

@section('content')
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Header -->
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-success mb-3">Tax Calculation Results</h1>
                <p class="lead text-muted">Detailed breakdown of import taxes and duties</p>
            </div>

            <!-- Results Card -->
            <div class="card border-0 shadow-lg">
                <div class="card-header bg-success text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="ti ti-check me-2"></i>Calculation Complete</h4>
                        <span class="badge bg-light text-success fs-6">Calculation ID: {{ $calculation->id ?? 'N/A' }}</span>
                    </div>
                </div>
                <div class="card-body p-4">
                    
                    <!-- Input Summary -->
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <h5 class="fw-semibold mb-3 text-primary"><i class="ti ti-clipboard-list me-2"></i>Input Details</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td class="fw-semibold">HS Code</td>
                                            <td>{{ $input['hs_code'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">Country of Origin</td>
                                            <td>{{ $input['country_of_origin'] }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">CIF Value</td>
                                            <td class="text-success fw-bold">KES {{ number_format($input['cif_value'], 2) }}</td>
                                        </tr>
                                        @if($input['weight'])
                                        <tr>
                                            <td class="fw-semibold">Weight</td>
                                            <td>{{ number_format($input['weight'], 2) }} KG</td>
                                        </tr>
                                        @endif
                                        @if($input['quantity'] && $input['quantity'] > 1)
                                        <tr>
                                            <td class="fw-semibold">Quantity</td>
                                            <td>{{ $input['quantity'] }} units</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5 class="fw-semibold mb-3 text-primary"><i class="ti ti-info-circle me-2"></i>HS Code Information</h5>
                            <div class="card bg-light border-0 h-100">
                                <div class="card-body">
                                    <p><strong>Code:</strong> {{ $result['hs_code_details']['code'] }}</p>
                                    <p><strong>Description:</strong> {{ $result['hs_code_details']['description'] }}</p>
                                    <p><strong>Duty Type:</strong> <span class="badge bg-info">{{ ucfirst($result['hs_code_details']['duty_type']) }}</span></p>
                                    <p><strong>Duty Value:</strong> {{ $result['hs_code_details']['duty_value'] }}{{ $result['hs_code_details']['duty_type'] === 'percentage' ? '%' : '' }}</p>
                                    @if($result['hs_code_details']['excise_applicable'])
                                        <p><strong>Excise:</strong> <span class="badge bg-warning">Applicable</span></p>
                                    @endif
                                    @if($result['hs_code_details']['sensitive'])
                                        <p><strong>Sensitive Goods:</strong> <span class="badge bg-danger">Yes</span></p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Base Information -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card border-primary">
                                <div class="card-header bg-primary bg-opacity-10">
                                    <h5 class="mb-0 text-primary"><i class="ti ti-calculator me-2"></i>Tax Base Calculation</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-md-4">
                                            <h6 class="text-muted">CIF Value</h6>
                                            <h4 class="text-success">KES {{ number_format($result['tax_base']['cif_value'], 2) }}</h4>
                                        </div>
                                        <div class="col-md-4">
                                            <h6 class="text-muted">Benchmark Applied</h6>
                                            <h4>
                                                @if($result['tax_base']['benchmark_applied'])
                                                    <span class="text-warning">Yes</span>
                                                    <br>
                                                    <small>KES {{ number_format($result['tax_base']['benchmark_value'], 2) }}</small>
                                                @else
                                                    <span class="text-success">No</span>
                                                @endif
                                            </h4>
                                        </div>
                                        <div class="col-md-4">
                                            <h6 class="text-muted">Final Tax Base</h6>
                                            <h4 class="text-primary">KES {{ number_format($result['tax_base']['final_tax_base'], 2) }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Breakdown -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h5 class="fw-semibold mb-3 text-primary"><i class="ti ti-receipt me-2"></i>Tax Breakdown</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Tax Type</th>
                                            <th>Calculation</th>
                                            <th class="text-end">Amount (KES)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="fw-semibold">Import Duty</td>
                                            <td>
                                                <small class="text-muted">
                                                    {{ $result['hs_code_details']['duty_type'] === 'percentage' ? 
                                                       $result['hs_code_details']['duty_value'] . '% of Tax Base' : 
                                                       'Flat Rate' }}
                                                </small>
                                            </td>
                                            <td class="text-end fw-semibold">{{ number_format($result['breakdown']['import_duty'], 2) }}</td>
                                        </tr>
                                        @if($result['breakdown']['excise_duty'] > 0)
                                        <tr>
                                            <td class="fw-semibold">Excise Duty</td>
                                            <td><small class="text-muted">Applicable for this HS code</small></td>
                                            <td class="text-end fw-semibold">{{ number_format($result['breakdown']['excise_duty'], 2) }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <td class="fw-semibold">VAT (16%)</td>
                                            <td><small class="text-muted">16% of (Tax Base + Import Duty)</small></td>
                                            <td class="text-end fw-semibold">{{ number_format($result['breakdown']['vat'], 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">IDF (2.5%)</td>
                                            <td><small class="text-muted">2.5% of Tax Base</small></td>
                                            <td class="text-end fw-semibold">{{ number_format($result['breakdown']['idf'], 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">RDL (2%)</td>
                                            <td><small class="text-muted">2% of Tax Base</small></td>
                                            <td class="text-end fw-semibold">{{ number_format($result['breakdown']['rdl'], 2) }}</td>
                                        </tr>
                                    </tbody>
                                    <tfoot class="table-success">
                                        <tr>
                                            <td colspan="2" class="fw-bold fs-5">Total Taxes Payable</td>
                                            <td class="text-end fw-bold fs-5">KES {{ number_format($result['total_taxes'], 2) }}</td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Summary Card -->
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card border-warning">
                                <div class="card-header bg-warning bg-opacity-10">
                                    <h5 class="mb-0 text-warning"><i class="ti ti-info-circle me-2"></i>Important Notes</h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled">
                                        <li class="mb-2"><i class="ti ti-alert-circle text-warning me-2"></i>This calculation is for estimation purposes only</li>
                                        <li class="mb-2"><i class="ti ti-clock text-warning me-2"></i>Rates are based on current tax regulations</li>
                                        <li class="mb-2"><i class="ti ti-currency-dollar text-warning me-2"></i>Final amounts may vary based on actual customs assessment</li>
                                        <li><i class="ti ti-calendar text-warning me-2"></i>Calculation timestamp: {{ now()->format('M j, Y H:i') }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-success text-center">
                                <div class="card-body">
                                    <h3 class="text-success mb-3">KES {{ number_format($result['total_taxes'], 2) }}</h3>
                                    <p class="text-muted mb-3">Total Payable</p>
                                    <div class="d-grid gap-2">
                                        <a href="{{ route('calculator') }}" class="btn btn-primary">
                                            <i class="ti ti-calculator me-2"></i>New Calculation
                                        </a>
                                        <button class="btn btn-outline-success" onclick="window.print()">
                                            <i class="ti ti-printer me-2"></i>Print Results
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border-radius: 12px;
}

.table th {
    border-top: none;
    font-weight: 600;
}

.btn {
    border-radius: 8px;
}
</style>
@endsection