<!-- HS Code Modal -->
<div class="modal fade" id="hsCodeModal" tabindex="-1" aria-labelledby="hsCodeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="hsCodeModalLabel">Browse HS Codes</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="input-group mb-3">
                    <input type="text" class="form-control" id="hsSearch" placeholder="Search HS codes or descriptions...">
                    <button class="btn btn-primary" type="button" id="searchHsCodes">
                        <i class="ti ti-search me-1"></i>Search
                    </button>
                </div>
                <div class="table-responsive" style="max-height: 400px;">
                    <table class="table table-hover">
                        <thead class="table-light sticky-top">
                            <tr>
                                <th>HS Code</th>
                                <th>Description</th>
                                <th>Duty Type</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="hsCodeResults">
                            @foreach($popularHsCodes as $hsCode)
                            <tr>
                                <td><strong>{{ $hsCode->hs_code }}</strong></td>
                                <td>{{ Str::limit($hsCode->description, 60) }}</td>
                                <td>
                                    <span class="badge bg-info">{{ ucfirst($hsCode->default_duty_type) }}</span>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-outline-primary select-hs-code" 
                                            data-code="{{ $hsCode->hs_code }}" 
                                            data-description="{{ $hsCode->description }}">
                                        Select
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>