@extends('layouts.guest')

@section('title', 'HS Code Not Found')

@section('content')
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Error Card -->
            <div class="card border-0 shadow-lg">
                <div class="card-header bg-danger text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="ti ti-alert-triangle me-2"></i>HS Code Not Found</h4>
                        <span class="badge bg-light text-danger fs-6">Code: {{ $hs_code }}</span>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="text-center mb-4">
                        <div class="mb-4">
                            <i class="ti ti-search-off text-danger" style="font-size: 4rem;"></i>
                        </div>
                        <h3 class="text-danger mb-3">We don't recognize this HS Code</h3>
                        <p class="text-muted lead mb-4">
                            The HS Code <strong>"{{ $hs_code }}"</strong> was not found in our database. 
                            Please check the code and try again.
                        </p>
                    </div>

                    <!-- Suggestions -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card border-warning">
                                <div class="card-header bg-warning bg-opacity-10">
                                    <h5 class="mb-0 text-warning"><i class="ti ti-lightbulb me-2"></i>What to do next?</h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-unstyled">
                                        <li class="mb-2"><i class="ti ti-check text-success me-2"></i>Double-check the HS code for typos</li>
                                        <li class="mb-2"><i class="ti ti-check text-success me-2"></i>Use the HS code browser to find the correct code</li>
                                        <li class="mb-2"><i class="ti ti-check text-success me-2"></i>Contact support if you need assistance</li>
                                        <li><i class="ti ti-check text-success me-2"></i>Try searching with a shorter code (4-6 digits)</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-info">
                                <div class="card-header bg-info bg-opacity-10">
                                    <h5 class="mb-0 text-info"><i class="ti ti-help me-2"></i>Need Help?</h5>
                                </div>
                                <div class="card-body">
                                    <p class="mb-3">Find the correct HS code using our tools:</p>
                                    <div class="d-grid gap-2">
                                        <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#hsCodeModal">
                                            <i class="ti ti-search me-2"></i>Browse HS Codes
                                        </button>
                                        <a href="{{ route('assistance') }}" class="btn btn-outline-info">
                                            <i class="ti ti-help me-2"></i>Get Assistance
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Retry Form -->
                    <div class="card border-primary">
                        <div class="card-header bg-primary bg-opacity-10">
                            <h5 class="mb-0 text-primary"><i class="ti ti-edit me-2"></i>Try Again</h5>
                        </div>
                        <div class="card-body">
                            <form id="retryForm" action="{{ route('calculator.calculate') }}" method="POST">
                                @csrf
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="retry_hs_code" class="form-label fw-semibold">HS Code *</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control" 
                                                       id="retry_hs_code" name="hs_code" 
                                                       placeholder="e.g., 870321" required
                                                       value="{{ $hs_code }}">
                                                <button type="button" class="btn btn-outline-secondary" 
                                                        data-bs-toggle="modal" data-bs-target="#hsCodeModal">
                                                    <i class="ti ti-search me-1"></i>Browse
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="retry_description" class="form-label fw-semibold">Goods Description</label>
                                            <input type="text" class="form-control" id="retry_description" 
                                                   name="description" placeholder="Describe the goods..."
                                                   value="{{ $input['description'] ?? '' }}">
                                        </div>
                                    </div>
                                </div>

                                <!-- Hidden fields to preserve other inputs -->
                                <input type="hidden" name="country_of_origin" value="{{ $input['country_of_origin'] ?? '' }}">
                                <input type="hidden" name="cif_value" value="{{ $input['cif_value'] ?? '' }}">
                                <input type="hidden" name="currency" value="{{ $input['currency'] ?? 'KES' }}">
                                <input type="hidden" name="weight" value="{{ $input['weight'] ?? '' }}">
                                <input type="hidden" name="quantity" value="{{ $input['quantity'] ?? 1 }}">
                                <input type="hidden" name="include_vat" value="{{ $input['include_vat'] ?? 1 }}">
                                <input type="hidden" name="include_idf" value="{{ $input['include_idf'] ?? 1 }}">
                                <input type="hidden" name="include_rdl" value="{{ $input['include_rdl'] ?? 1 }}">

                                <div class="mt-4">
                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <a href="{{ route('calculator') }}" class="btn btn-outline-secondary me-md-2">
                                            <i class="ti ti-arrow-back me-2"></i>Back to Calculator
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="ti ti-calculator me-2"></i>Retry Calculation
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include the HS Code Modal from the main calculator -->
@include('calculator.partials.hs-code-modal')

<style>
.card {
    border-radius: 12px;
}

.btn {
    border-radius: 8px;
}

.form-control {
    border-radius: 6px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-focus on the HS code input
    document.getElementById('retry_hs_code').focus();
    
    // HS code selection from modal
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('select-hs-code')) {
            const code = e.target.getAttribute('data-code');
            const description = e.target.getAttribute('data-description');
            
            document.getElementById('retry_hs_code').value = code;
            document.getElementById('retry_description').value = description;
            
            const modal = bootstrap.Modal.getInstance(document.getElementById('hsCodeModal'));
            modal.hide();
        }
    });
});
</script>
@endsection