@extends('layouts.admin')

@section('title', 'Tax Configuration Details')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0">{{ $taxConfig->tax_name }} Configuration</h4>
                <a href="{{ route('admin.tax-configs.index') }}" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left me-1"></i>Back to List
                </a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Tax Name:</strong> {{ $taxConfig->tax_name }}</p>
                        <p><strong>Rate Type:</strong> <span class="badge bg-info">{{ ucfirst($taxConfig->rate_type) }}</span></p>
                        <p><strong>Rate:</strong> 
                            @if($taxConfig->rate_type === 'percentage')
                                {{ $taxConfig->rate }}%
                            @else
                                KES {{ number_format($taxConfig->rate, 2) }}
                            @endif
                        </p>
                        <p><strong>Minimum Amount:</strong> 
                            @if($taxConfig->min_amount)
                                KES {{ number_format($taxConfig->min_amount, 2) }}
                            @else
                                <span class="text-muted">Not set</span>
                            @endif
                        </p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Status:</strong> 
                            @if($taxConfig->active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </p>
                        <p><strong>Effective From:</strong> {{ $taxConfig->effective_from->format('M j, Y') }}</p>
                        <p><strong>Effective To:</strong> 
                            @if($taxConfig->effective_to)
                                {{ $taxConfig->effective_to->format('M j, Y') }}
                            @else
                                <span class="text-muted">Ongoing</span>
                            @endif
                        </p>
                        <p><strong>Created:</strong> {{ $taxConfig->created_at->format('M j, Y H:i') }}</p>
                        <p><strong>Last Updated:</strong> {{ $taxConfig->updated_at->format('M j, Y H:i') }}</p>
                    </div>
                </div>
                
                @if($taxConfig->remarks)
                <div class="row mt-3">
                    <div class="col-12">
                        <h5>Remarks</h5>
                        <p class="bg-light p-3 rounded">{{ $taxConfig->remarks }}</p>
                    </div>
                </div>
                @endif
            </div>
            <div class="card-footer">
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.tax-configs.edit', $taxConfig->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <form action="{{ route('admin.tax-configs.destroy', $taxConfig->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this tax configuration?')">
                            <i class="fas fa-trash me-2"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection