@extends('layouts.admin')

@section('title', 'Tax Configurations')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Tax Configurations</h2>
                <a href="{{ route('admin.tax-configs.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Tax Configuration
                </a>
            </div>
            <p class="text-muted">Manage tax rates and rules (VAT, IDF, RDL, Excise, Import Duty)</p>
        </div>
    </div>
</div>

@include('partials.admin.alerts')

<!-- Search and Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form action="{{ route('admin.tax-configs.index') }}" method="GET">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="search">Search</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" placeholder="Search tax name or remarks...">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="tax_name">Tax Type</label>
                        <select class="form-control" id="tax_name" name="tax_name">
                            <option value="">All Types</option>
                            <option value="VAT" {{ request('tax_name') == 'VAT' ? 'selected' : '' }}>VAT</option>
                            <option value="IDF" {{ request('tax_name') == 'IDF' ? 'selected' : '' }}>IDF</option>
                            <option value="RDL" {{ request('tax_name') == 'RDL' ? 'selected' : '' }}>RDL</option>
                            <option value="Excise" {{ request('tax_name') == 'Excise' ? 'selected' : '' }}>Excise</option>
                            <option value="Import Duty" {{ request('tax_name') == 'Import Duty' ? 'selected' : '' }}>Import Duty</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="active">Status</label>
                        <select class="form-control" id="active" name="active">
                            <option value="">All Status</option>
                            <option value="1" {{ request('active') == '1' ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ request('active') == '0' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Tax Configs Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">Tax Configurations</h4>
        <a href="{{ route('admin.tax-configs.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add New
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Tax Name</th>
                        <th>Rate Type</th>
                        <th>Rate</th>
                        <th>Min Amount</th>
                        <th>Status</th>
                        <th>Effective From</th>
                        <th>Effective To</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($taxConfigs as $taxConfig)
                    <tr>
                        <td>
                            <strong>{{ $taxConfig->tax_name }}</strong>
                            @if($taxConfig->remarks)
                                <br><small class="text-muted">{{ Str::limit($taxConfig->remarks, 30) }}</small>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst($taxConfig->rate_type) }}</span>
                        </td>
                        <td>
                            @if($taxConfig->rate_type === 'percentage')
                                {{ $taxConfig->rate }}%
                            @else
                                KES {{ number_format($taxConfig->rate, 2) }}
                            @endif
                        </td>
                        <td>
                            @if($taxConfig->min_amount)
                                KES {{ number_format($taxConfig->min_amount, 2) }}
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($taxConfig->active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>{{ $taxConfig->effective_from->format('M j, Y') }}</td>
                        <td>
                            @if($taxConfig->effective_to)
                                {{ $taxConfig->effective_to->format('M j, Y') }}
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @include('partials.admin.tables.action-buttons', [
                                'viewUrl' => route('admin.tax-configs.show', $taxConfig->id),
                                'editUrl' => route('admin.tax-configs.edit', $taxConfig->id),
                                'deleteUrl' => route('admin.tax-configs.destroy', $taxConfig->id)
                            ])
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        @if($taxConfigs->hasPages())
            <div class="mt-3">
                {{ $taxConfigs->links() }}
            </div>
        @endif
    </div>
</div>
@endsection