@extends('layouts.admin')

@section('title', 'Create Tax Configuration')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Create New Tax Configuration</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.tax-configs.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="tax_name" class="form-label">Tax Name *</label>
                                <select class="form-control @error('tax_name') is-invalid @enderror" 
                                        id="tax_name" name="tax_name" required>
                                    <option value="">Select Tax Type</option>
                                    <option value="VAT" {{ old('tax_name') == 'VAT' ? 'selected' : '' }}>VAT</option>
                                    <option value="IDF" {{ old('tax_name') == 'IDF' ? 'selected' : '' }}>IDF</option>
                                    <option value="RDL" {{ old('tax_name') == 'RDL' ? 'selected' : '' }}>RDL</option>
                                    <option value="Excise" {{ old('tax_name') == 'Excise' ? 'selected' : '' }}>Excise</option>
                                    <option value="Import Duty" {{ old('tax_name') == 'Import Duty' ? 'selected' : '' }}>Import Duty</option>
                                </select>
                                @error('tax_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="rate_type" class="form-label">Rate Type *</label>
                                <select class="form-control @error('rate_type') is-invalid @enderror" 
                                        id="rate_type" name="rate_type" required>
                                    <option value="">Select Rate Type</option>
                                    <option value="percentage" {{ old('rate_type') == 'percentage' ? 'selected' : '' }}>Percentage</option>
                                    <option value="flat" {{ old('rate_type') == 'flat' ? 'selected' : '' }}>Flat Rate</option>
                                </select>
                                @error('rate_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="rate" class="form-label">Rate *</label>
                                <input type="number" step="0.0001" class="form-control @error('rate') is-invalid @enderror" 
                                       id="rate" name="rate" value="{{ old('rate') }}" required>
                                @error('rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">
                                    Enter percentage (e.g., 16) or flat amount in KES
                                </small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="min_amount" class="form-label">Minimum Amount</label>
                                <input type="number" step="0.01" class="form-control @error('min_amount') is-invalid @enderror" 
                                       id="min_amount" name="min_amount" value="{{ old('min_amount') }}">
                                @error('min_amount')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Minimum applicable amount (optional)</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_from" class="form-label">Effective From *</label>
                                <input type="date" class="form-control @error('effective_from') is-invalid @enderror" 
                                       id="effective_from" name="effective_from" value="{{ old('effective_from') }}" required>
                                @error('effective_from')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_to" class="form-label">Effective To</label>
                                <input type="date" class="form-control @error('effective_to') is-invalid @enderror" 
                                       id="effective_to" name="effective_to" value="{{ old('effective_to') }}">
                                @error('effective_to')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Leave empty if ongoing</small>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea class="form-control @error('remarks') is-invalid @enderror" 
                                  id="remarks" name="remarks" rows="3">{{ old('remarks') }}</textarea>
                        @error('remarks')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group mt-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="active" name="active" value="1" {{ old('active', true) ? 'checked' : '' }}>
                            <label class="form-check-label" for="active">Active</label>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Create Tax Configuration
                        </button>
                        <a href="{{ route('admin.tax-configs.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Tax Configuration Guidelines</h5>
            </div>
            <div class="card-body">
                <h6>Standard Tax Rates (Kenya)</h6>
                <ul class="small">
                    <li><strong>VAT:</strong> 16% (standard rate)</li>
                    <li><strong>IDF:</strong> 2.5% of CIF value</li>
                    <li><strong>RDL:</strong> 2% of CIF value</li>
                    <li><strong>Excise:</strong> Varies by product type</li>
                </ul>
                
                <h6>Rate Types</h6>
                <ul class="small">
                    <li><strong>Percentage:</strong> Applied as % of tax base</li>
                    <li><strong>Flat Rate:</strong> Fixed amount per consignment</li>
                </ul>
                
                <h6>Effective Dates</h6>
                <p class="small">Set effective dates to manage tax rate changes over time.</p>
            </div>
        </div>
    </div>
</div>
@endsection