@extends('layouts.admin')

@section('title', 'Tax Calculation Results - Admin')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-check-circle me-2"></i>Tax Calculation Results
                        </h4>
                        <div class="btn-group">
                            <button class="btn btn-light btn-sm" onclick="window.print()">
                                <i class="fas fa-print me-1"></i>Print
                            </button>
                            <a href="{{ route('admin.tax-calculator') }}" class="btn btn-light btn-sm">
                                <i class="fas fa-calculator me-1"></i>New Calculation
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    
                    <!-- Calculation Header -->
                    <div class="row mb-4">
                        <div class="col-md-8">
                            <div class="d-flex align-items-center">
                                <div class="bg-success rounded-circle p-3 me-3">
                                    <i class="fas fa-calculator fa-2x text-white"></i>
                                </div>
                                <div>
                                    <h3 class="text-success mb-1">Calculation Complete</h3>
                                    <p class="text-muted mb-0">Detailed breakdown of import taxes and duties</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 text-end">
                            <div class="card bg-light border-0">
                                <div class="card-body py-2">
                                    <small class="text-muted">Calculation ID</small>
                                    <div class="fw-bold">{{ $calculation->id ?? 'N/A' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Input Summary & HS Code Info -->
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <div class="card border-primary">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0"><i class="fas fa-clipboard-list me-2"></i>Input Details</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold" width="40%">HS Code</td>
                                                    <td>
                                                        <strong>{{ $input['hs_code'] }}</strong>
                                                        <a href="{{ route('admin.hs-codes.index') }}?search={{ $input['hs_code'] }}" 
                                                           class="btn btn-sm btn-outline-primary ms-2" target="_blank">
                                                            <i class="fas fa-external-link-alt"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Country of Origin</td>
                                                    <td>{{ $input['country_of_origin'] }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">CIF Value</td>
                                                    <td class="text-success fw-bold">
                                                        {{ $input['currency'] }} {{ number_format($input['cif_value'], 2) }}
                                                    </td>
                                                </tr>
                                                @if($input['weight'] ?? false)
                                                <tr>
                                                    <td class="fw-semibold">Weight</td>
                                                    <td>{{ number_format($input['weight'], 2) }} KG</td>
                                                </tr>
                                                @endif
                                                @if(($input['quantity'] ?? 1) > 1)
                                                <tr>
                                                    <td class="fw-semibold">Quantity</td>
                                                    <td>{{ $input['quantity'] }} units</td>
                                                </tr>
                                                @endif
                                                @if($input['description'] ?? false)
                                                <tr>
                                                    <td class="fw-semibold">Description</td>
                                                    <td>{{ $input['description'] }}</td>
                                                </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>HS Code Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted">Code</small>
                                            <div class="fw-bold">{{ $result['hs_code_details']['code'] }}</div>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">Duty Type</small>
                                            <div>
                                                <span class="badge bg-info">{{ ucfirst($result['hs_code_details']['duty_type']) }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-12">
                                            <small class="text-muted">Description</small>
                                            <div class="fw-bold">{{ $result['hs_code_details']['description'] }}</div>
                                        </div>
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-6">
                                            <small class="text-muted">Duty Value</small>
                                            <div class="fw-bold">
                                                {{ $result['hs_code_details']['duty_value'] }}
                                                @if($result['hs_code_details']['duty_type'] === 'percentage')% @endif
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">Status</small>
                                            <div>
                                                @if($result['hs_code_details']['excise_applicable'])
                                                    <span class="badge bg-warning me-1">Excise</span>
                                                @endif
                                                @if($result['hs_code_details']['sensitive'])
                                                    <span class="badge bg-danger">Sensitive</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Base Information -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card border-warning">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0"><i class="fas fa-balance-scale me-2"></i>Tax Base Calculation</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-md-3">
                                            <h6 class="text-muted">CIF Value</h6>
                                            <h4 class="text-success">KES {{ number_format($result['tax_base']['cif_value'], 2) }}</h4>
                                        </div>
                                        <div class="col-md-3">
                                            <h6 class="text-muted">Benchmark Value</h6>
                                            <h4 class="text-warning">KES {{ number_format($result['tax_base']['benchmark_value'] ?? 0, 2) }}</h4>
                                        </div>
                                        <div class="col-md-3">
                                            <h6 class="text-muted">Benchmark Applied</h6>
                                            <h4>
                                                @if($result['tax_base']['benchmark_applied'])
                                                    <span class="badge bg-warning">Yes</span>
                                                @else
                                                    <span class="badge bg-success">No</span>
                                                @endif
                                            </h4>
                                        </div>
                                        <div class="col-md-3">
                                            <h6 class="text-muted">Final Tax Base</h6>
                                            <h4 class="text-primary">KES {{ number_format($result['tax_base']['final_tax_base'], 2) }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Breakdown -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card border-success">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0"><i class="fas fa-receipt me-2"></i>Tax Breakdown</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover">
                                            <thead class="table-light">
                                                <tr>
                                                    <th width="25%">Tax Type</th>
                                                    <th width="35%">Calculation Basis</th>
                                                    <th width="20%" class="text-center">Rate</th>
                                                    <th width="20%" class="text-end">Amount (KES)</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold">Import Duty</td>
                                                    <td>
                                                        <small class="text-muted">
                                                            {{ $result['hs_code_details']['duty_type'] === 'percentage' ? 
                                                               $result['hs_code_details']['duty_value'] . '% of Tax Base' : 
                                                               'Flat Rate' }}
                                                        </small>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="badge bg-info">
                                                            {{ $result['hs_code_details']['duty_value'] }}
                                                            @if($result['hs_code_details']['duty_type'] === 'percentage')% @endif
                                                        </span>
                                                    </td>
                                                    <td class="text-end fw-semibold">{{ number_format($result['breakdown']['import_duty'], 2) }}</td>
                                                </tr>
                                                @if($result['breakdown']['excise_duty'] > 0)
                                                <tr>
                                                    <td class="fw-semibold">Excise Duty</td>
                                                    <td><small class="text-muted">Applicable for this HS code</small></td>
                                                    <td class="text-center">
                                                        <span class="badge bg-warning">Variable</span>
                                                    </td>
                                                    <td class="text-end fw-semibold">{{ number_format($result['breakdown']['excise_duty'], 2) }}</td>
                                                </tr>
                                                @endif
                                                <tr>
                                                    <td class="fw-semibold">VAT</td>
                                                    <td><small class="text-muted">16% of (Tax Base + Import Duty + Excise + IDF + RDL)</small></td>
                                                    <td class="text-center">
                                                        <span class="badge bg-success">16%</span>
                                                    </td>
                                                    <td class="text-end fw-semibold">{{ number_format($result['breakdown']['vat'], 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">IDF</td>
                                                    <td><small class="text-muted">2.5% of Tax Base</small></td>
                                                    <td class="text-center">
                                                        <span class="badge bg-primary">2.5%</span>
                                                    </td>
                                                    <td class="text-end fw-semibold">{{ number_format($result['breakdown']['idf'], 2) }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">RDL</td>
                                                    <td><small class="text-muted">2% of Tax Base</small></td>
                                                    <td class="text-center">
                                                        <span class="badge bg-secondary">2%</span>
                                                    </td>
                                                    <td class="text-end fw-semibold">{{ number_format($result['breakdown']['rdl'], 2) }}</td>
                                                </tr>
                                            </tbody>
                                            <tfoot class="table-success">
                                                <tr>
                                                    <td colspan="3" class="fw-bold fs-5">Total Taxes Payable</td>
                                                    <td class="text-end fw-bold fs-5">KES {{ number_format($result['total_taxes'], 2) }}</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0"><i class="fas fa-chart-pie me-2"></i>Tax Distribution</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <canvas id="taxDistributionChart" width="400" height="200"></canvas>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="tax-breakdown">
                                                @php
                                                    $total = $result['total_taxes'];
                                                    $importDutyPercent = ($result['breakdown']['import_duty'] / $total) * 100;
                                                    $vatPercent = ($result['breakdown']['vat'] / $total) * 100;
                                                    $idfPercent = ($result['breakdown']['idf'] / $total) * 100;
                                                    $rdlPercent = ($result['breakdown']['rdl'] / $total) * 100;
                                                    $excisePercent = ($result['breakdown']['excise_duty'] / $total) * 100;
                                                @endphp
                                                
                                                <div class="mb-3">
                                                    <div class="d-flex justify-content-between mb-1">
                                                        <span>Import Duty</span>
                                                        <span>{{ number_format($importDutyPercent, 1) }}%</span>
                                                    </div>
                                                    <div class="progress" style="height: 8px;">
                                                        <div class="progress-bar bg-primary" style="width: {{ $importDutyPercent }}%"></div>
                                                    </div>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <div class="d-flex justify-content-between mb-1">
                                                        <span>VAT</span>
                                                        <span>{{ number_format($vatPercent, 1) }}%</span>
                                                    </div>
                                                    <div class="progress" style="height: 8px;">
                                                        <div class="progress-bar bg-success" style="width: {{ $vatPercent }}%"></div>
                                                    </div>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <div class="d-flex justify-content-between mb-1">
                                                        <span>IDF</span>
                                                        <span>{{ number_format($idfPercent, 1) }}%</span>
                                                    </div>
                                                    <div class="progress" style="height: 8px;">
                                                        <div class="progress-bar bg-info" style="width: {{ $idfPercent }}%"></div>
                                                    </div>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <div class="d-flex justify-content-between mb-1">
                                                        <span>RDL</span>
                                                        <span>{{ number_format($rdlPercent, 1) }}%</span>
                                                    </div>
                                                    <div class="progress" style="height: 8px;">
                                                        <div class="progress-bar bg-secondary" style="width: {{ $rdlPercent }}%"></div>
                                                    </div>
                                                </div>
                                                
                                                @if($result['breakdown']['excise_duty'] > 0)
                                                <div class="mb-3">
                                                    <div class="d-flex justify-content-between mb-1">
                                                        <span>Excise Duty</span>
                                                        <span>{{ number_format($excisePercent, 1) }}%</span>
                                                    </div>
                                                    <div class="progress" style="height: 8px;">
                                                        <div class="progress-bar bg-warning" style="width: {{ $excisePercent }}%"></div>
                                                    </div>
                                                </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-success text-center">
                                <div class="card-body">
                                    <div class="mb-4">
                                        <i class="fas fa-money-bill-wave text-success fa-4x mb-3"></i>
                                        <h2 class="text-success">KES {{ number_format($result['total_taxes'], 2) }}</h2>
                                        <p class="text-muted">Total Taxes Payable</p>
                                    </div>
                                    <div class="d-grid gap-2">
                                        <a href="{{ route('admin.tax-calculator') }}" class="btn btn-primary">
                                            <i class="fas fa-calculator me-2"></i>New Calculation
                                        </a>
                                        <button class="btn btn-outline-success" onclick="window.print()">
                                            <i class="fas fa-print me-2"></i>Print Results
                                        </button>
                                        <a href="{{ route('admin.calculation-logs.index') }}" class="btn btn-outline-info">
                                            <i class="fas fa-history me-2"></i>View History
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Information -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card border-secondary">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="mb-0"><i class="fas fa-clock me-2"></i>Calculation Details</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <small class="text-muted">Calculation Timestamp</small>
                                            <div class="fw-bold">{{ now()->format('M j, Y H:i:s') }}</div>
                                        </div>
                                        <div class="col-md-4">
                                            <small class="text-muted">Calculated By</small>
                                            <div class="fw-bold">{{ auth()->user()->name }}</div>
                                        </div>
                                        <div class="col-md-4">
                                            <small class="text-muted">Session ID</small>
                                            <div class="fw-bold text-muted">{{ substr(session()->getId(), 0, 8) }}...</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.card {
    border-radius: 10px;
}

.table th {
    border-top: none;
    font-weight: 600;
}

.btn {
    border-radius: 6px;
}

.progress {
    border-radius: 10px;
}

@media print {
    .btn, .card-header .btn-group {
        display: none !important;
    }
    
    .card {
        border: 1px solid #ddd !important;
    }
    
    .card-header {
        background: #f8f9fa !important;
        color: #000 !important;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tax Distribution Chart
    const ctx = document.getElementById('taxDistributionChart').getContext('2d');
    const taxData = {
        labels: [
            'Import Duty', 
            'VAT', 
            'IDF', 
            'RDL'
            @if($result['breakdown']['excise_duty'] > 0)
            , 'Excise Duty'
            @endif
        ],
        datasets: [{
            data: [
                {{ $result['breakdown']['import_duty'] }},
                {{ $result['breakdown']['vat'] }},
                {{ $result['breakdown']['idf'] }},
                {{ $result['breakdown']['rdl'] }}
                @if($result['breakdown']['excise_duty'] > 0)
                , {{ $result['breakdown']['excise_duty'] }}
                @endif
            ],
            backgroundColor: [
                '#0d6efd', // Primary - Import Duty
                '#198754', // Success - VAT
                '#0dcaf0', // Info - IDF
                '#6c757d'  // Secondary - RDL
                @if($result['breakdown']['excise_duty'] > 0)
                , '#ffc107' // Warning - Excise
                @endif
            ],
            borderWidth: 2,
            borderColor: '#fff'
        }]
    };

    new Chart(ctx, {
        type: 'doughnut',
        data: taxData,
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = context.raw || 0;
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = Math.round((value / total) * 100);
                            return `${label}: KES ${value.toLocaleString('en-KE', {minimumFractionDigits: 2})} (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });
});
</script>
@endpush