<!-- HS Code Modal -->
<div class="modal fade" id="hsCodeModal" tabindex="-1" aria-labelledby="hsCodeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="hsCodeModalLabel">
                    <i class="fas fa-search me-2"></i>Browse HS Codes
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-3">
                    <div class="col-md-8">
                        <div class="input-group">
                            <input type="text" class="form-control" id="hsSearch" placeholder="Search HS codes or descriptions...">
                            <button class="btn btn-primary" type="button" id="searchHsCodes">
                                <i class="fas fa-search me-1"></i>Search
                            </button>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <select class="form-select" id="dutyTypeFilter">
                            <option value="">All Duty Types</option>
                            <option value="percentage">Percentage</option>
                            <option value="flat">Flat Rate</option>
                            <option value="per_kg">Per KG</option>
                            <option value="per_container">Per Container</option>
                        </select>
                    </div>
                </div>
                
                <div class="table-responsive" style="max-height: 500px;">
                    <table class="table table-hover table-sm">
                        <thead class="table-light sticky-top">
                            <tr>
                                <th width="15%">HS Code</th>
                                <th width="45%">Description</th>
                                <th width="15%">Duty Type</th>
                                <th width="15%">Duty Value</th>
                                <th width="10%">Action</th>
                            </tr>
                        </thead>
                        <tbody id="hsCodeResults">
                            @foreach($popularHsCodes as $hsCode)
                            <tr>
                                <td><strong>{{ $hsCode->hs_code }}</strong></td>
                                <td>{{ Str::limit($hsCode->description, 80) }}</td>
                                <td>
                                    <span class="badge bg-info">{{ ucfirst($hsCode->default_duty_type) }}</span>
                                </td>
                                <td>
                                    {{ $hsCode->default_duty_value }}
                                    @if($hsCode->default_duty_type === 'percentage')% @endif
                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-outline-primary select-hs-code" 
                                            data-code="{{ $hsCode->hs_code }}" 
                                            data-description="{{ $hsCode->description }}">
                                        <i class="fas fa-check me-1"></i>Select
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <div class="text-muted small">
                    Showing {{ $popularHsCodes->count() ?? 0 }} of {{ $totalHsCodes ?? 0 }} HS codes
                </div>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // HS Code selection
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('select-hs-code')) {
            const code = e.target.getAttribute('data-code');
            const description = e.target.getAttribute('data-description');
            
            document.getElementById('hs_code').value = code;
            document.getElementById('description').value = description;
            
            const modal = bootstrap.Modal.getInstance(document.getElementById('hsCodeModal'));
            modal.hide();
            
            showHsCodeDetails(code);
            updateQuickPreview();
        }
    });

    // HS code search
    document.getElementById('searchHsCodes').addEventListener('click', searchHsCodes);
    document.getElementById('hsSearch').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            searchHsCodes();
        }
    });

    // Duty type filter
    document.getElementById('dutyTypeFilter').addEventListener('change', searchHsCodes);

    function searchHsCodes() {
        const query = document.getElementById('hsSearch').value;
        const dutyType = document.getElementById('dutyTypeFilter').value;
        
        let url = '/admin/api/hs-codes/search?search=' + encodeURIComponent(query);
        if (dutyType) {
            url += '&duty_type=' + dutyType;
        }

        fetch(url)
            .then(response => response.json())
            .then(data => {
                const resultsBody = document.getElementById('hsCodeResults');
                resultsBody.innerHTML = '';
                
                data.forEach(hsCode => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td><strong>${hsCode.hs_code}</strong></td>
                        <td>${hsCode.description}</td>
                        <td><span class="badge bg-info">${hsCode.default_duty_type}</span></td>
                        <td>${hsCode.default_duty_value}${hsCode.default_duty_type === 'percentage' ? '%' : ''}</td>
                        <td>
                            <button type="button" class="btn btn-sm btn-outline-primary select-hs-code" 
                                    data-code="${hsCode.hs_code}" 
                                    data-description="${hsCode.description}">
                                <i class="fas fa-check me-1"></i>Select
                            </button>
                        </td>
                    `;
                    resultsBody.appendChild(row);
                });

                if (data.length === 0) {
                    resultsBody.innerHTML = `
                        <tr>
                            <td colspan="5" class="text-center text-muted py-4">
                                <i class="fas fa-search fa-2x mb-2"></i>
                                <p>No HS codes found matching your search</p>
                            </td>
                        </tr>
                    `;
                }
            });
    }
});
</script>