@extends('layouts.admin')

@section('title', 'Calculation History - Admin')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-history me-2"></i>Calculation History
                        </h4>
                        <a href="{{ route('admin.tax-calculator') }}" class="btn btn-light btn-sm">
                            <i class="fas fa-calculator me-1"></i>New Calculation
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if($calculations->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>HS Code</th>
                                        <th>Country</th>
                                        <th>CIF Value</th>
                                        <th>Total Taxes</th>
                                        <th>Calculated By</th>
                                        <th>Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($calculations as $calculation)
                                    <tr>
                                        <td>
                                            <strong>#{{ $calculation->id }}</strong>
                                        </td>
                                        <td>
                                            <code>{{ $calculation->input['hs_code'] ?? 'N/A' }}</code>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $calculation->input['country_of_origin'] ?? 'N/A' }}</span>
                                        </td>
                                        <td>
                                            KES {{ number_format($calculation->input['cif_value'] ?? 0, 2) }}
                                        </td>
                                        <td>
                                            <strong class="text-success">KES {{ number_format($calculation->total_payable ?? 0, 2) }}</strong>
                                        </td>
                                        <td>
                                            {{ $calculation->user->name ?? 'System' }}
                                        </td>
                                        <td>
                                            <small>{{ $calculation->created_at->format('M j, Y H:i') }}</small>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm">
                                                <a href="{{ route('admin.calculation-logs.show', $calculation->id) }}" 
                                                   class="btn btn-outline-primary" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.calculation-logs.recalculate', $calculation->id) }}" 
                                                   class="btn btn-outline-success" title="Recalculate">
                                                    <i class="fas fa-redo"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing {{ $calculations->firstItem() }} to {{ $calculations->lastItem() }} of {{ $calculations->total() }} calculations
                            </div>
                            {{ $calculations->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-calculator fa-4x text-muted mb-3"></i>
                            <h4 class="text-muted">No Calculation History</h4>
                            <p class="text-muted">No tax calculations have been performed yet.</p>
                            <a href="{{ route('admin.tax-calculator') }}" class="btn btn-primary">
                                <i class="fas fa-calculator me-2"></i>Perform First Calculation
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection