@extends('layouts.admin')

@section('title', 'System Health')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-heartbeat me-2"></i>System Health
        </h1>
        <div>
            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#clearCacheModal">
                <i class="fas fa-broom me-2"></i>Clear Cache
            </button>
            <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#backupModal">
                <i class="fas fa-download me-2"></i>Run Backup
            </button>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- System Information -->
    <div class="row mb-4">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-info-circle me-2"></i>System Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>PHP Version</strong></td>
                                    <td>{{ $systemInfo['php_version'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Laravel Version</strong></td>
                                    <td>{{ $systemInfo['laravel_version'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Server Software</strong></td>
                                    <td>{{ $systemInfo['server_software'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Server OS</strong></td>
                                    <td>{{ $systemInfo['server_os'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Memory Limit</strong></td>
                                    <td>{{ $systemInfo['memory_limit'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Max Execution Time</strong></td>
                                    <td>{{ $systemInfo['max_execution_time'] }} seconds</td>
                                </tr>
                                <tr>
                                    <td><strong>Timezone</strong></td>
                                    <td>{{ $systemInfo['timezone'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Environment</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $systemInfo['environment'] === 'production' ? 'success' : 'warning' }}">
                                            {{ $systemInfo['environment'] }}
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-success text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-database me-2"></i>Database Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>Driver</strong></td>
                                    <td>{{ $databaseInfo['driver'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Database</strong></td>
                                    <td>{{ $databaseInfo['database'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Connection Status</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $databaseInfo['connection_status'] === 'Connected' ? 'success' : 'danger' }}">
                                            {{ $databaseInfo['connection_status'] }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Table Count</strong></td>
                                    <td>{{ $databaseInfo['table_count'] }}</td>
                                </tr>
                                @if(isset($databaseInfo['error']))
                                <tr>
                                    <td><strong>Error</strong></td>
                                    <td class="text-danger">{{ $databaseInfo['error'] }}</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>

                    @if(count($databaseInfo['table_sizes']) > 0)
                    <h6 class="mt-4 mb-3">Largest Tables</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-striped">
                            <thead>
                                <tr>
                                    <th>Table</th>
                                    <th>Size</th>
                                    <th>Rows</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach(array_slice($databaseInfo['table_sizes'], 0, 5) as $table)
                                <tr>
                                    <td>{{ $table->table }}</td>
                                    <td>{{ $table->size_mb }} MB</td>
                                    <td>{{ number_format($table->rows) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Storage & Cache -->
    <div class="row mb-4">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-info text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-hdd me-2"></i>Storage Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>Local Disk Status</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $storageInfo['local_disk_status'] === 'OK' ? 'success' : 'danger' }}">
                                            {{ $storageInfo['local_disk_status'] }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Public Disk Status</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $storageInfo['public_disk_status'] === 'OK' ? 'success' : 'danger' }}">
                                            {{ $storageInfo['public_disk_status'] }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Local Disk Free Space</strong></td>
                                    <td>{{ $storageInfo['local_disk_free_space'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Public Disk Free Space</strong></td>
                                    <td>{{ $storageInfo['public_disk_free_space'] }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header bg-warning text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-bolt me-2"></i>Cache Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm">
                            <tbody>
                                <tr>
                                    <td><strong>Cache Driver</strong></td>
                                    <td>{{ $cacheInfo['driver'] }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Cache Status</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $cacheInfo['status'] === 'OK' ? 'success' : 'danger' }}">
                                            {{ $cacheInfo['status'] }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Cache Prefix</strong></td>
                                    <td>{{ $cacheInfo['prefix'] }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Application Information -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header bg-secondary text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-cube me-2"></i>Application Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Application Name</strong></td>
                                            <td>{{ $applicationInfo['name'] }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Application URL</strong></td>
                                            <td>{{ $applicationInfo['url'] }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Debug Mode</strong></td>
                                            <td>
                                                <span class="badge bg-{{ $applicationInfo['debug'] === 'Enabled' ? 'warning' : 'success' }}">
                                                    {{ $applicationInfo['debug'] }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Maintenance Mode</strong></td>
                                            <td>
                                                <span class="badge bg-{{ $applicationInfo['maintenance_mode'] === 'Enabled' ? 'danger' : 'success' }}">
                                                    {{ $applicationInfo['maintenance_mode'] }}
                                                </span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="table-responsive">
                                <table class="table table-bordered table-sm">
                                    <tbody>
                                        <tr>
                                            <td><strong>Last Calculation</strong></td>
                                            <td>{{ $applicationInfo['last_calculation'] }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Calculations</strong></td>
                                            <td>{{ number_format($applicationInfo['total_calculations']) }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Users</strong></td>
                                            <td>{{ number_format($applicationInfo['total_users']) }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Backup Information -->
<!-- Backup Information -->
<div class="row">
    <div class="col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                <h6 class="m-0 font-weight-bold">
                    <i class="fas fa-download me-2"></i>Backup Information
                </h6>
                <div>
                    <span class="badge bg-light text-dark me-2">
                        {{ $backupInfo['backup_count'] }} backups
                    </span>
                    <span class="badge bg-light text-dark">
                        Total: {{ $backupInfo['total_backup_size'] }}
                    </span>
                </div>
            </div>
            <div class="card-body">
                @if($backupInfo['backup_count'] > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Backup File</th>
                                <th>Size</th>
                                <th>Modified</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($backupInfo['backups'] as $backup)
                            <tr>
                                <td>
                                    <i class="fas fa-file-archive me-2 text-primary"></i>
                                    {{ $backup['name'] }}
                                </td>
                                <td>{{ $backup['size'] }}</td>
                                <td>{{ date('Y-m-d H:i:s', $backup['modified']) }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.system-health.download-backup', ['filename' => $backup['name']]) }}"
                                           class="btn btn-primary" title="Download">
                                            <i class="fas fa-download"></i>
                                        </a>
                                        <button type="button" class="btn btn-danger" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#deleteBackupModal"
                                                data-backup-name="{{ $backup['name'] }}"
                                                title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <div class="text-center py-4">
                    <i class="fas fa-file-archive fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No backups found</h5>
                    <p class="text-muted">Create your first backup using the button above.</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
<!-- Clear Cache Modal -->
<div class="modal fade" id="clearCacheModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Clear Cache</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to clear all cache? This will clear:</p>
                <ul>
                    <li>Application Cache</li>
                    <li>Configuration Cache</li>
                    <li>Route Cache</li>
                    <li>View Cache</li>
                </ul>
                <p class="text-warning"><strong>Note:</strong> This action may temporarily slow down the application.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="{{ route('admin.system-health.clear-cache') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-warning">Clear Cache</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Backup Modal -->
<div class="modal fade" id="backupModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Run Backup</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to run a system backup? This will backup:</p>
                <ul>
                    <li>Database</li>
                    <li>Application Files</li>
                </ul>
                <p class="text-info"><strong>Note:</strong> Make sure you have the backup package installed (spatie/laravel-backup).</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="{{ route('admin.system-health.run-backup') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-success">Run Backup</button>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Delete Backup Modal -->
<div class="modal fade" id="deleteBackupModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Backup</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this backup file?</p>
                <p class="text-danger"><strong>Warning:</strong> This action cannot be undone.</p>
                <p>File: <strong id="backupFileName"></strong></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteBackupForm" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete Backup</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Delete backup modal handler
    const deleteBackupModal = document.getElementById('deleteBackupModal');
    if (deleteBackupModal) {
        deleteBackupModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            const backupName = button.getAttribute('data-backup-name');
            const form = document.getElementById('deleteBackupForm');
            
            document.getElementById('backupFileName').textContent = backupName;
            
            // Fix: Use proper route construction
            const baseUrl = "{{ route('admin.system-health.delete-backup', ['filename' => 'PLACEHOLDER']) }}";
            form.action = baseUrl.replace('PLACEHOLDER', encodeURIComponent(backupName));
        });
    }
});
</script>
@endpush