@extends('layouts.admin')

@section('title', 'Role Management')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    @if(auth()->user()->canManageRoles() || auth()->user()->isFirstAdmin())
                    <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i> Create Role
                    </a>
                    @endif
                </div>
                <h4 class="page-title">Role Management</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-striped">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Slug</th>
                                    <th>Users</th>
                                    <th>Permissions</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($roles as $role)
                                <tr>
                                    <td>
                                        <strong>{{ $role->name }}</strong>
                                        @if($role->slug === 'super_admin')
                                            <span class="badge bg-danger ms-1">System Role</span>
                                        @endif
                                        <br>
                                        <small class="text-muted">{{ $role->description }}</small>
                                    </td>
                                    <td><code>{{ $role->slug }}</code></td>
                                    <td>
                                        <span class="badge bg-primary">{{ $role->users_count }} users</span>
                                    </td>
                                    <td>
                                        <small>
                                            @if(in_array('*', $role->permissions ?? []))
                                                <span class="badge bg-success">All Permissions</span>
                                            @else
                                                {{ count($role->permissions ?? []) }} permissions
                                            @endif
                                        </small>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $role->is_active ? 'success' : 'danger' }}">
                                            {{ $role->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($role->slug !== 'super_admin')
                                        <div class="btn-group">
                                            <a href="{{ route('admin.roles.edit', $role) }}" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($role->users_count == 0)
                                            <form action="{{ route('admin.roles.destroy', $role) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="btn btn-sm btn-outline-danger"
                                                        onclick="return confirm('Are you sure?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                        @else
                                        <span class="text-muted">System Role</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection