@extends('layouts.admin')

@section('title', 'Tax Collection Report')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-money-bill-wave me-2"></i>Tax Collection Report
        </h1>
        <div>
            <a href="{{ route('admin.reports.export', 'tax-collection') . '?' . http_build_query(request()->query()) }}" 
               class="btn btn-success btn-sm">
                <i class="fas fa-download me-2"></i>Export CSV
            </a>
            <a href="{{ route('admin.reports.index') }}" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left me-2"></i>Back to Reports
            </a>
        </div>
    </div>

    <!-- Date Filter -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label for="start_date" class="form-label">Start Date</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" 
                           value="{{ request('start_date', now()->subDays(30)->format('Y-m-d')) }}">
                </div>
                <div class="col-md-3">
                    <label for="end_date" class="form-label">End Date</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" 
                           value="{{ request('end_date', now()->format('Y-m-d')) }}">
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-filter me-2"></i>Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary Cards -->
    @if(isset($summary))
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Calculations
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format($summary->total_calculations) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calculator fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Revenue
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                KES {{ number_format($summary->total_revenue, 2) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Average Tax
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                KES {{ number_format($summary->average_tax, 2) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Highest Tax
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                KES {{ number_format($summary->highest_tax, 2) }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-arrow-up fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Tax Collection Table -->
    <div class="card shadow mb-4">
        <div class="card-header bg-primary text-white">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-table me-2"></i>Daily Tax Collection
                <small class="float-end">
                    Period: {{ $dateRange['start']->format('M j, Y') }} - {{ $dateRange['end']->format('M j, Y') }}
                </small>
            </h6>
        </div>
        <div class="card-body">
            @if($taxCollection->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="taxCollectionTable">
                        <thead class="table-light">
                            <tr>
                                <th>Date</th>
                                <th>Calculations</th>
                                <th>Total Revenue (KES)</th>
                                <th>Average Tax (KES)</th>
                                <th>Trend</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($taxCollection as $collection)
                                <tr>
                                    <td>{{ \Carbon\Carbon::parse($collection->date)->format('M j, Y') }}</td>
                                    <td class="text-center">{{ number_format($collection->total_calculations) }}</td>
                                    <td class="text-end">KES {{ number_format($collection->total_revenue, 2) }}</td>
                                    <td class="text-end">KES {{ number_format($collection->average_tax, 2) }}</td>
                                    <td class="text-center">
                                        @php
                                            $trend = $collection->total_revenue > 0 ? 'up' : 'flat';
                                        @endphp
                                        <i class="fas fa-arrow-{{ $trend }} text-{{ $trend == 'up' ? 'success' : 'secondary' }}"></i>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        @if(isset($summary))
                        <tfoot>
                            <tr class="table-active">
                                <th>Total</th>
                                <th class="text-center">{{ number_format($summary->total_calculations) }}</th>
                                <th class="text-end">KES {{ number_format($summary->total_revenue, 2) }}</th>
                                <th class="text-end">KES {{ number_format($summary->average_tax, 2) }}</th>
                                <th></th>
                            </tr>
                        </tfoot>
                        @endif
                    </table>
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-chart-bar fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No tax collection data found for the selected period</h5>
                    <p class="text-muted">Try adjusting your date range or check back later.</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Chart Section (Placeholder for future chart implementation) -->
    <div class="card shadow mb-4">
        <div class="card-header bg-success text-white">
            <h6 class="m-0 font-weight-bold">
                <i class="fas fa-chart-line me-2"></i>Revenue Trend
            </h6>
        </div>
        <div class="card-body">
            <div class="text-center py-5">
                <i class="fas fa-chart-bar fa-4x text-muted mb-3"></i>
                <h5 class="text-muted">Chart Visualization</h5>
                <p class="text-muted">
                    Chart visualization can be implemented using Chart.js, Highcharts, or any other charting library.
                    Data is available in the table above.
                </p>
                <div class="mt-3">
                    <span class="badge bg-info">Total Days: {{ $taxCollection->count() }}</span>
                    <span class="badge bg-success">Data Range: {{ $dateRange['start']->format('M j') }} - {{ $dateRange['end']->format('M j, Y') }}</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Simple table sorting functionality
    document.addEventListener('DOMContentLoaded', function() {
        const table = document.getElementById('taxCollectionTable');
        if (table) {
            const headers = table.querySelectorAll('thead th');
            headers.forEach((header, index) => {
                header.style.cursor = 'pointer';
                header.addEventListener('click', function() {
                    sortTable(index);
                });
            });

            function sortTable(columnIndex) {
                const tbody = table.querySelector('tbody');
                const rows = Array.from(tbody.querySelectorAll('tr'));
                
                rows.sort((a, b) => {
                    const aText = a.cells[columnIndex].textContent.trim();
                    const bText = b.cells[columnIndex].textContent.trim();
                    
                    // Handle numeric values
                    if (columnIndex > 0) {
                        const aNum = parseFloat(aText.replace(/[^\d.-]/g, ''));
                        const bNum = parseFloat(bText.replace(/[^\d.-]/g, ''));
                        return aNum - bNum;
                    }
                    
                    // Handle date values
                    if (columnIndex === 0) {
                        return new Date(aText) - new Date(bText);
                    }
                    
                    return aText.localeCompare(bText);
                });

                // Reverse if already sorted
                if (tbody.getAttribute('data-sorted') === columnIndex.toString()) {
                    rows.reverse();
                    tbody.removeAttribute('data-sorted');
                } else {
                    tbody.setAttribute('data-sorted', columnIndex.toString());
                }

                // Reappend sorted rows
                rows.forEach(row => tbody.appendChild(row));
            }
        }
    });
</script>
@endpush