@extends('layouts.admin')

@section('title', 'HS Code Details: ' . $hsCode->hs_code)

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0">HS Code: {{ $hsCode->hs_code }}</h4>
                <div class="btn-group">
                    <a href="{{ route('admin.hs-codes.edit', $hsCode->id) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit me-1"></i>Edit
                    </a>
                    <a href="{{ route('admin.hs-codes.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i>Back
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>HS Code:</strong> {{ $hsCode->hs_code }}</p>
                        <p><strong>Description:</strong> {{ $hsCode->description }}</p>
                        <p><strong>Duty Type:</strong> <span class="badge bg-info text-capitalize">{{ $hsCode->default_duty_type }}</span></p>
                        <p><strong>Duty Value:</strong> 
                            @if($hsCode->default_duty_type === 'percentage')
                                {{ $hsCode->default_duty_value }}%
                            @else
                                KES {{ number_format($hsCode->default_duty_value, 2) }}
                            @endif
                        </p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Excise Applicable:</strong> 
                            @if($hsCode->excise_applicable)
                                <span class="badge bg-warning">Yes</span>
                            @else
                                <span class="badge bg-secondary">No</span>
                            @endif
                        </p>
                        <p><strong>Sensitive Goods:</strong> 
                            @if($hsCode->sensitive)
                                <span class="badge bg-danger">Yes</span>
                            @else
                                <span class="badge bg-success">No</span>
                            @endif
                        </p>
                        <p><strong>Created:</strong> {{ $hsCode->created_at->format('M j, Y H:i') }}</p>
                        <p><strong>Last Updated:</strong> {{ $hsCode->updated_at->format('M j, Y H:i') }}</p>
                    </div>
                </div>
                
                @if($hsCode->excise_applicable && $hsCode->excise_formula)
                <div class="row mt-3">
                    <div class="col-12">
                        <h5>Excise Formula</h5>
                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($hsCode->excise_formula, JSON_PRETTY_PRINT) }}</code></pre>
                    </div>
                </div>
                @endif
            </div>
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <small class="text-muted">ID: {{ $hsCode->id }}</small>
                    <form action="{{ route('admin.hs-codes.destroy', $hsCode->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this HS Code? This action cannot be undone.')">
                            <i class="fas fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <!-- Related Information Card -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Related Information</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <h6>Benchmarks</h6>
                    @if($hsCode->benchmarks()->exists())
                        <p>{{ $hsCode->benchmarks()->count() }} active benchmark(s)</p>
                        <a href="#" class="btn btn-outline-info btn-sm">View Benchmarks</a>
                    @else
                        <p class="text-muted">No benchmarks defined</p>
                    @endif
                </div>
                
                <div class="mb-3">
                    <h6>Country Overrides</h6>
                    @if($hsCode->countryOverrides()->exists())
                        <p>{{ $hsCode->countryOverrides()->count() }} country override(s)</p>
                        <a href="#" class="btn btn-outline-warning btn-sm">View Overrides</a>
                    @else
                        <p class="text-muted">No country overrides</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection