@extends('layouts.admin')

@section('title', 'HS Codes Management')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>HS Codes Management</h2>
                <a href="{{ route('admin.hs-codes.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add HS Code
                </a>
            </div>
            <p class="text-muted">Manage Harmonized System codes and their tax configurations</p>
        </div>
    </div>
</div>

@include('partials.admin.alerts')

<!-- Search and Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form action="{{ route('admin.hs-codes.index') }}" method="GET">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="search">Search HS Code or Description</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" placeholder="Enter HS code or description...">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="duty_type">Duty Type</label>
                        <select class="form-control" id="duty_type" name="duty_type">
                            <option value="">All Types</option>
                            <option value="percentage" {{ request('duty_type') == 'percentage' ? 'selected' : '' }}>Percentage</option>
                            <option value="flat" {{ request('duty_type') == 'flat' ? 'selected' : '' }}>Flat Rate</option>
                            <option value="per_kg" {{ request('duty_type') == 'per_kg' ? 'selected' : '' }}>Per KG</option>
                            <option value="per_container" {{ request('duty_type') == 'per_container' ? 'selected' : '' }}>Per Container</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="excise_applicable">Excise Applicable</label>
                        <select class="form-control" id="excise_applicable" name="excise_applicable">
                            <option value="">All</option>
                            <option value="1" {{ request('excise_applicable') == '1' ? 'selected' : '' }}>Yes</option>
                            <option value="0" {{ request('excise_applicable') == '0' ? 'selected' : '' }}>No</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- HS Codes Table - Simple Approach -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">HS Codes</h4>
        <a href="{{ route('admin.hs-codes.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add New
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>HS Code</th>
                        <th>Description</th>
                        <th>Duty Type</th>
                        <th>Duty Value</th>
                        <th>Excise</th>
                        <th>Sensitive</th>
                        <th>Last Updated</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($hsCodes as $hsCode)
                    <tr>
                        <td>
                            <strong>{{ $hsCode->hs_code }}</strong>
                        </td>
                        <td>
                            <span title="{{ $hsCode->description }}">
                                {{ Str::limit($hsCode->description, 50) }}
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst($hsCode->default_duty_type) }}</span>
                        </td>
                        <td>
                            @if($hsCode->default_duty_type === 'percentage')
                                {{ $hsCode->default_duty_value }}%
                            @else
                                KES {{ number_format($hsCode->default_duty_value, 2) }}
                            @endif
                        </td>
                        <td>
                            @if($hsCode->excise_applicable)
                                <span class="badge bg-warning">Yes</span>
                            @else
                                <span class="badge bg-secondary">No</span>
                            @endif
                        </td>
                        <td>
                            @if($hsCode->sensitive)
                                <span class="badge bg-danger">Yes</span>
                            @else
                                <span class="badge bg-success">No</span>
                            @endif
                        </td>
                        <td>{{ $hsCode->updated_at->format('M j, Y') }}</td>
                        <td>
                            @include('partials.admin.tables.action-buttons', [
                                'viewUrl' => route('admin.hs-codes.show', $hsCode->id),
                                'editUrl' => route('admin.hs-codes.edit', $hsCode->id),
                                'deleteUrl' => route('admin.hs-codes.destroy', $hsCode->id)
                            ])
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        @if($hsCodes->hasPages())
            <div class="mt-3">
                {{ $hsCodes->links() }}
            </div>
        @endif
    </div>
</div>

<!-- Bulk Actions -->
<div class="card mt-4">
    <div class="card-header">
        <h5 class="mb-0">Bulk Operations</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <a href="{{ route('admin.hs-codes.import') }}" class="btn btn-outline-primary">
                    <i class="fas fa-upload me-2"></i>Bulk Import HS Codes
                </a>
                <a href="{{ route('admin.hs-codes.template') }}" class="btn btn-outline-success ms-2">
                    <i class="fas fa-download me-2"></i>Download Template
                </a>
            </div>
            <div class="col-md-6 text-end">
                <a href="{{ route('admin.hs-codes.export') }}" class="btn btn-outline-success">
                    <i class="fas fa-download me-2"></i>Export to CSV
                </a>
            </div>
        </div>
    </div>
</div>
@endsection