@extends('layouts.admin')

@section('title', 'Bulk Import HS Codes')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Bulk Import HS Codes</h4>
            </div>
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif

                @if(session('import_errors'))
                    <div class="alert alert-warning">
                        <h6>Import Errors:</h6>
                        <ul class="mb-0">
                            @foreach(session('import_errors') as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('admin.hs-codes.bulk-import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group mb-3">
                        <label for="import_file">Select CSV File</label>
                        <input type="file" class="form-control @error('import_file') is-invalid @enderror" 
                               id="import_file" name="import_file" accept=".csv,.txt" required>
                        @error('import_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">
                            Supported formats: CSV, TXT (Max: 10MB)
                        </small>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-upload me-2"></i>Import HS Codes
                        </button>
                        <a href="{{ route('admin.hs-codes.template') }}" class="btn btn-outline-success">
                            <i class="fas fa-download me-2"></i>Download Template
                        </a>
                        <a href="{{ route('admin.hs-codes.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Import Instructions</h5>
            </div>
            <div class="card-body">
                <h6>File Format Requirements:</h6>
                <ul class="small">
                    <li>CSV file with UTF-8 encoding</li>
                    <li>First row must contain headers</li>
                    <li>Required columns: hs_code, description, default_duty_type, default_duty_value</li>
                    <li>Optional columns: excise_applicable, sensitive</li>
                </ul>

                <h6>Column Descriptions:</h6>
                <ul class="small">
                    <li><strong>hs_code:</strong> Unique HS code (max 20 chars)</li>
                    <li><strong>description:</strong> Product description (max 500 chars)</li>
                    <li><strong>default_duty_type:</strong> percentage, flat, per_kg, per_container</li>
                    <li><strong>default_duty_value:</strong> Numeric value</li>
                    <li><strong>excise_applicable:</strong> 1 for Yes, 0 for No</li>
                    <li><strong>sensitive:</strong> 1 for Yes, 0 for No</li>
                </ul>

                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    Existing HS codes will be updated, new ones will be created.
                </div>
            </div>
        </div>
    </div>
</div>
@endsection