@extends('layouts.admin')

@section('title', 'Edit HS Code')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Edit HS Code: {{ $hsCode->hs_code }}</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.hs-codes.update', $hsCode->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    @include('partials.admin.forms.hs-code')
                    
                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update HS Code
                        </button>
                        <a href="{{ route('admin.hs-codes.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">HS Code Information</h5>
            </div>
            <div class="card-body">
                <p><strong>Created:</strong> {{ $hsCode->created_at->format('M j, Y H:i') }}</p>
                <p><strong>Last Updated:</strong> {{ $hsCode->updated_at->format('M j, Y H:i') }}</p>
                
                @if($hsCode->benchmarks()->exists())
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    This HS Code has {{ $hsCode->benchmarks()->count() }} benchmark(s).
                </div>
                @endif
                
                @if($hsCode->countryOverrides()->exists())
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    This HS Code has {{ $hsCode->countryOverrides()->count() }} country override(s).
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection