@extends('layouts.admin')

@section('title', 'Create HS Code')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Create New HS Code</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.hs-codes.store') }}" method="POST">
                    @csrf
                    
                    @include('partials.admin.forms.hs-code')
                    
                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Create HS Code
                        </button>
                        <a href="{{ route('admin.hs-codes.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">HS Code Guidelines</h5>
            </div>
            <div class="card-body">
                <h6>HS Code Format</h6>
                <ul class="small">
                    <li>Use standard HS code format (e.g., 870321)</li>
                    <li>Maximum 20 characters</li>
                    <li>Must be unique</li>
                </ul>
                
                <h6>Duty Types</h6>
                <ul class="small">
                    <li><strong>Percentage:</strong> Applied as % of CIF value</li>
                    <li><strong>Flat Rate:</strong> Fixed amount in KES</li>
                    <li><strong>Per KG:</strong> Amount per kilogram</li>
                    <li><strong>Per Container:</strong> Amount per container</li>
                </ul>
                
                <h6>Sensitive Goods</h6>
                <p class="small">Mark as sensitive for goods requiring special handling or approval.</p>
            </div>
        </div>
    </div>
</div>
@endsection