@extends('layouts.admin')

@section('title', 'Manage FAQs')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">FAQs</li>
                    </ol>
                </div>
                <h4 class="page-title">Manage FAQs</h4>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-4">
                            <a href="{{ route('admin.faqs.create') }}" class="btn btn-success">
                                <i class="fas fa-plus me-1"></i> Add New FAQ
                            </a>
                        </div>
                        <div class="col-sm-8">
                            <div class="text-sm-end">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown">
                                        Bulk Actions
                                    </button>
                                    <div class="dropdown-menu">
                                        <button class="dropdown-item" onclick="bulkAction('publish')">
                                            <i class="fas fa-check text-success me-2"></i>Publish Selected
                                        </button>
                                        <button class="dropdown-item" onclick="bulkAction('unpublish')">
                                            <i class="fas fa-times text-warning me-2"></i>Unpublish Selected
                                        </button>
                                        <div class="dropdown-divider"></div>
                                        <button class="dropdown-item text-danger" onclick="bulkAction('delete')">
                                            <i class="fas fa-trash me-2"></i>Delete Selected
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <form id="bulkForm" action="{{ route('admin.faqs.bulk-action') }}" method="POST">
                            @csrf
                            <input type="hidden" name="action" id="bulkAction">
                            
                            <table class="table table-centered table-striped dt-responsive nowrap w-100" id="faqs-datatable">
                                <thead class="table-light">
                                    <tr>
                                        <th style="width: 20px;">
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" id="selectAll">
                                                <label class="form-check-label" for="selectAll"></label>
                                            </div>
                                        </th>
                                        <th>Question</th>
                                        <th>Category</th>
                                        <th>Order</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th style="width: 120px;">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($faqs as $faq)
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input select-item" name="ids[]" value="{{ $faq->id }}">
                                            </div>
                                        </td>
                                        <td>
                                            <div class="fw-semibold">{{ Str::limit($faq->question, 60) }}</div>
                                        </td>
                                        <td>
                                            <span class="badge bg-light text-dark">{{ $faq->category }}</span>
                                        </td>
                                        <td>{{ $faq->order }}</td>
                                        <td>
                                            @if($faq->is_published)
                                                <span class="badge bg-success">Published</span>
                                            @else
                                                <span class="badge bg-warning">Draft</span>
                                            @endif
                                        </td>
                                        <td>{{ $faq->created_at->format('M j, Y') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('admin.faqs.edit', $faq->id) }}" 
                                                   class="btn btn-sm btn-primary" 
                                                   data-bs-toggle="tooltip" 
                                                   title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                
                                                <form action="{{ route('admin.faqs.toggle-status', $faq->id) }}" 
                                                      method="POST" 
                                                      class="d-inline">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" 
                                                            class="btn btn-sm {{ $faq->is_published ? 'btn-warning' : 'btn-success' }}"
                                                            data-bs-toggle="tooltip" 
                                                            title="{{ $faq->is_published ? 'Unpublish' : 'Publish' }}">
                                                        <i class="fas {{ $faq->is_published ? 'fa-eye-slash' : 'fa-eye' }}"></i>
                                                    </button>
                                                </form>
                                                
                                                <form action="{{ route('admin.faqs.destroy', $faq->id) }}" 
                                                      method="POST" 
                                                      class="d-inline"
                                                      onsubmit="return confirm('Are you sure you want to delete this FAQ?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" 
                                                            class="btn btn-sm btn-danger"
                                                            data-bs-toggle="tooltip" 
                                                            title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Select all functionality
    document.getElementById('selectAll').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.select-item');
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
    });

    // Bulk action functionality
    function bulkAction(action) {
        const selectedItems = document.querySelectorAll('.select-item:checked');
        if (selectedItems.length === 0) {
            alert('Please select at least one FAQ to perform this action.');
            return;
        }

        if (action === 'delete' && !confirm('Are you sure you want to delete the selected FAQs?')) {
            return;
        }

        document.getElementById('bulkAction').value = action;
        document.getElementById('bulkForm').submit();
    }

    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endpush