@extends('layouts.admin')

@section('title', 'Exchange Rates Management')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-exchange-alt me-2"></i>Exchange Rates Management
                        </h4>
                        <a href="{{ route('admin.exchange-rates.create') }}" class="btn btn-light btn-sm">
                            <i class="fas fa-plus me-1"></i>Add Exchange Rate
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <form action="{{ route('admin.exchange-rates.index') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="base_currency" class="form-label">Base Currency</label>
                                    <select class="form-control" id="base_currency" name="base_currency">
                                        <option value="">All Base Currencies</option>
                                        @foreach($currencies ?? [] as $currency)
                                            <option value="{{ $currency->code }}" 
                                                {{ request('base_currency') == $currency->code ? 'selected' : '' }}>
                                                {{ $currency->code }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="target_currency" class="form-label">Target Currency</label>
                                    <select class="form-control" id="target_currency" name="target_currency">
                                        <option value="">All Target Currencies</option>
                                        @foreach($currencies ?? [] as $currency)
                                            @if($currency->code != 'KES')
                                            <option value="{{ $currency->code }}" 
                                                {{ request('target_currency') == $currency->code ? 'selected' : '' }}>
                                                {{ $currency->code }}
                                            </option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_active" class="form-label">Status</label>
                                    <select class="form-control" id="is_active" name="is_active">
                                        <option value="">All Status</option>
                                        <option value="1" {{ request('is_active') === '1' ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ request('is_active') === '0' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="effective_date" class="form-label">Effective Date</label>
                                    <input type="date" class="form-control" id="effective_date" name="effective_date" 
                                           value="{{ request('effective_date') }}">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Apply Filters</button>
                                <a href="{{ route('admin.exchange-rates.index') }}" class="btn btn-secondary">Clear Filters</a>
                            </div>
                        </div>
                    </form>

                    @if($exchangeRates->count())
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Base Currency</th>
                                    <th>Target Currency</th>
                                    <th>Exchange Rate</th>
                                    <th>Effective Date</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($exchangeRates as $rate)
                                <tr>
                                    <td>
                                        <span class="badge bg-success">{{ $rate->base_currency }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ $rate->target_currency }}</span>
                                    </td>
                                    <td>
                                        <strong>1 {{ $rate->target_currency }} = {{ number_format($rate->rate, 4) }} {{ $rate->base_currency }}</strong>
                                    </td>
                                    <td>{{ $rate->effective_date->format('M j, Y') }}</td>
                                    <td>
                                        @if($rate->is_active)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-secondary">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $rate->created_at->format('M j, Y') }}</small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.exchange-rates.edit', $rate->id) }}" 
                                               class="btn btn-warning" title="Edit Rate">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($rate->is_active)
                                            <form action="{{ route('admin.exchange-rates.destroy', $rate->id) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger" 
                                                        title="Deactivate Rate"
                                                        onclick="return confirm('Are you sure you want to deactivate this exchange rate?')">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </form>
                                            @else
                                            <form action="{{ route('admin.exchange-rates.update', $rate->id) }}" 
                                                  method="POST" class="d-inline">
                                                @csrf
                                                @method('PUT')
                                                <input type="hidden" name="is_active" value="1">
                                                <button type="submit" class="btn btn-success" 
                                                        title="Activate Rate"
                                                        onclick="return confirm('Are you sure you want to activate this exchange rate?')">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div class="text-muted">
                            Showing {{ $exchangeRates->firstItem() }} to {{ $exchangeRates->lastItem() }} of {{ $exchangeRates->total() }} exchange rates
                        </div>
                        {{ $exchangeRates->links() }}
                    </div>
                    @else
                    <div class="text-center py-5">
                        <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No Exchange Rates Found</h5>
                        <p class="text-muted mb-4">No exchange rates have been added yet.</p>
                        <a href="{{ route('admin.exchange-rates.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add First Exchange Rate
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection