@extends('layouts.admin')

@section('title', 'Edit Exchange Rate')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-edit me-2"></i>Edit Exchange Rate
                        </h4>
                        <a href="{{ route('admin.exchange-rates.index') }}" class="btn btn-light btn-sm">
                            <i class="fas fa-arrow-left me-1"></i>Back to Rates
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.exchange-rates.update', $exchangeRate->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="base_currency" class="form-label fw-semibold">Base Currency *</label>
                                    <select class="form-control @error('base_currency') is-invalid @enderror" 
                                            id="base_currency" name="base_currency" required>
                                        <option value="">Select Base Currency</option>
                                        @foreach($currencies as $currency)
                                            <option value="{{ $currency->code }}" 
                                                {{ old('base_currency', $exchangeRate->base_currency) == $currency->code ? 'selected' : '' }}>
                                                {{ $currency->code }} - {{ $currency->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div class="form-text">The base currency for the exchange rate</div>
                                    @error('base_currency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="target_currency" class="form-label fw-semibold">Target Currency *</label>
                                    <select class="form-control @error('target_currency') is-invalid @enderror" 
                                            id="target_currency" name="target_currency" required>
                                        <option value="">Select Target Currency</option>
                                        @foreach($currencies as $currency)
                                            @if($currency->code != 'KES')
                                            <option value="{{ $currency->code }}" 
                                                {{ old('target_currency', $exchangeRate->target_currency) == $currency->code ? 'selected' : '' }}>
                                                {{ $currency->code }} - {{ $currency->name }}
                                            </option>
                                            @endif
                                        @endforeach
                                    </select>
                                    <div class="form-text">The currency being converted to</div>
                                    @error('target_currency')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="rate" class="form-label fw-semibold">Exchange Rate *</label>
                                    <input type="number" step="0.0001" class="form-control @error('rate') is-invalid @enderror" 
                                           id="rate" name="rate" value="{{ old('rate', $exchangeRate->rate) }}" 
                                           placeholder="e.g., 150.5000" required>
                                    <div class="form-text">
                                        Rate format: 1 Target Currency = X Base Currency
                                    </div>
                                    @error('rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="effective_date" class="form-label fw-semibold">Effective Date *</label>
                                    <input type="date" class="form-control @error('effective_date') is-invalid @enderror" 
                                           id="effective_date" name="effective_date" 
                                           value="{{ old('effective_date', $exchangeRate->effective_date->format('Y-m-d')) }}" required>
                                    <div class="form-text">The date when this rate becomes effective</div>
                                    @error('effective_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                               value="1" {{ old('is_active', $exchangeRate->is_active) ? 'checked' : '' }}>
                                        <label class="form-check-label fw-semibold" for="is_active">
                                            Active Rate
                                        </label>
                                    </div>
                                    <div class="form-text">Active rates are used in calculations</div>
                                </div>
                            </div>
                        </div>

                        <!-- Rate Preview -->
                        <div class="card bg-light mt-3">
                            <div class="card-body">
                                <h6 class="text-primary mb-3">Current Rate Preview</h6>
                                <div class="row text-center">
                                    <div class="col-4">
                                        <small class="text-muted">Base Currency</small>
                                        <div class="fw-bold">{{ $exchangeRate->base_currency }}</div>
                                    </div>
                                    <div class="col-4">
                                        <small class="text-muted">Target Currency</small>
                                        <div class="fw-bold">{{ $exchangeRate->target_currency }}</div>
                                    </div>
                                    <div class="col-4">
                                        <small class="text-muted">Exchange Rate</small>
                                        <div class="fw-bold text-success">
                                            1 {{ $exchangeRate->target_currency }} = {{ number_format($exchangeRate->rate, 4) }} {{ $exchangeRate->base_currency }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end mt-4">
                            <a href="{{ route('admin.exchange-rates.index') }}" class="btn btn-secondary me-md-2">
                                <i class="fas fa-times me-2"></i>Cancel
                            </a>
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save me-2"></i>Update Exchange Rate
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <!-- Rate Information -->
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Rate Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">Created</small>
                        <div class="fw-bold">{{ $exchangeRate->created_at->format('M j, Y H:i') }}</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Last Updated</small>
                        <div class="fw-bold">{{ $exchangeRate->updated_at->format('M j, Y H:i') }}</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Current Status</small>
                        <div>
                            @if($exchangeRate->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card border-success mt-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-bolt me-2"></i>Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.exchange-rates.show', $exchangeRate->id) }}" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-eye me-1"></i>View Details
                        </a>
                        @if($exchangeRate->is_active)
                        <form action="{{ route('admin.exchange-rates.destroy', $exchangeRate->id) }}" method="POST" class="d-grid">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-outline-danger btn-sm" 
                                    onclick="return confirm('Are you sure you want to deactivate this exchange rate?')">
                                <i class="fas fa-times me-1"></i>Deactivate Rate
                            </button>
                        </form>
                        @else
                        <form action="{{ route('admin.exchange-rates.update', $exchangeRate->id) }}" method="POST" class="d-grid">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="is_active" value="1">
                            <button type="submit" class="btn btn-outline-success btn-sm" 
                                    onclick="return confirm('Are you sure you want to activate this exchange rate?')">
                                <i class="fas fa-check me-1"></i>Activate Rate
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Similar Rates -->
            <div class="card border-warning mt-4">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Similar Rates</h5>
                </div>
                <div class="card-body">
                    @php
                        $similarRates = \App\Models\ExchangeRate::where('base_currency', $exchangeRate->base_currency)
                            ->where('target_currency', $exchangeRate->target_currency)
                            ->where('id', '!=', $exchangeRate->id)
                            ->orderBy('effective_date', 'desc')
                            ->limit(3)
                            ->get();
                    @endphp
                    
                    @if($similarRates->count())
                        @foreach($similarRates as $similarRate)
                        <div class="border-bottom pb-2 mb-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ number_format($similarRate->rate, 4) }}</strong>
                                    <br>
                                    <small class="text-muted">{{ $similarRate->effective_date->format('M j, Y') }}</small>
                                </div>
                                <div>
                                    @if($similarRate->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    @else
                        <p class="text-muted small">No similar rates found.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection