@extends('layouts.admin')

@section('title', 'Admin Dashboard')

@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="row align-items-center mb-4">
        <div class="col">
            <h3 class="fw-bold mb-1">Dashboard Overview</h3>
            <p class="text-muted mb-0">Welcome back! Here's what's happening with your tax simulator today.</p>
        </div>
        <div class="col-auto">
            <div class="btn-group">
                <a href="{{ route('calculator') }}" class="btn btn-primary" target="_blank">
                    <i class="ti ti-calculator me-2"></i>Public Calculator
                </a>
                <a href="{{ route('admin.tax-calculator') }}" class="btn btn-success">
                    <i class="ti ti-calculator-filled me-2"></i>Admin Calculator
                </a>
            </div>
        </div>
    </div>

    <!-- Statistics Grid -->
    <div class="row g-3 mb-4">
        <!-- HS Codes Card -->
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded bg-primary bg-opacity-10 p-3">
                                <i class="ti ti-barcode text-primary fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h4 class="mb-1 fw-bold">{{ number_format($stats['total_hs_codes']) }}</h4>
                            <p class="text-muted mb-0">HS Codes</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Country Overrides Card -->
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded bg-success bg-opacity-10 p-3">
                                <i class="ti ti-world text-success fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h4 class="mb-1 fw-bold">{{ number_format($stats['total_country_overrides']) }}</h4>
                            <p class="text-muted mb-0">Country Overrides</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Today's Calculations Card -->
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded bg-info bg-opacity-10 p-3">
                                <i class="ti ti-calculator text-info fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h4 class="mb-1 fw-bold">{{ number_format($stats['today_calculations']) }}</h4>
                            <p class="text-muted mb-0">Today's Calculations</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Revenue Card -->
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded bg-warning bg-opacity-10 p-3">
                                <i class="ti ti-currency-dollar text-warning fs-4"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h4 class="mb-1 fw-bold">KES {{ number_format($stats['total_revenue'], 2) }}</h4>
                            <p class="text-muted mb-0">Today's Revenue</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="row g-4">
        <!-- Recent Calculations -->
        <div class="col-xl-8">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 py-3">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="ti ti-history me-2"></i>Recent Calculations
                    </h5>
                </div>
                <div class="card-body">
                    @if($recentCalculations->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>HS Code</th>
                                        <th>Country</th>
                                        <th>CIF Value</th>
                                        <th>Total Payable</th>
                                        <th>User</th>
                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentCalculations as $calculation)
                                    <tr>
                                        <td>
                                            <span class="fw-semibold">{{ $calculation->input['hs_code'] ?? 'N/A' }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-light text-dark">{{ $calculation->input['country_of_origin'] ?? 'N/A' }}</span>
                                        </td>
                                        <td>
                                            <span class="text-success fw-semibold">KES {{ number_format($calculation->input['cif_value'] ?? 0, 2) }}</span>
                                        </td>
                                        <td>
                                            <span class="fw-bold text-primary">KES {{ number_format($calculation->total_payable, 2) }}</span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-xs me-2">
                                                    <div class="avatar-title bg-primary bg-opacity-10 rounded-circle">
                                                        <i class="ti ti-user text-primary fs-3"></i>
                                                    </div>
                                                </div>
                                                <span>{{ $calculation->user->name ?? 'System' }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ $calculation->created_at->diffForHumans() }}</small>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="avatar-lg mx-auto mb-3">
                                <div class="avatar-title bg-light rounded-circle">
                                    <i class="ti ti-calculator text-muted fs-1"></i>
                                </div>
                            </div>
                            <h5 class="text-muted">No calculations yet</h5>
                            <p class="text-muted mb-4">Start using the tax calculator to see recent activity here.</p>
                            <a href="{{ route('admin.tax-calculator') }}" class="btn btn-primary">
                                <i class="ti ti-calculator me-2"></i>Start Calculating
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Quick Actions & System Status -->
        <div class="col-xl-4">
            <!-- Quick Actions -->

            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-transparent border-0 py-3">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="ti ti-bolt me-2"></i>Quick Actions
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <!-- Use index routes which are safer than create routes -->
                        <a href="{{ route('admin.hs-codes.index') }}" class="btn btn-outline-primary text-start">
                            <i class="ti ti-barcode me-2"></i>Manage HS Codes
                        </a>
                        <a href="{{ route('admin.tax-configs.index') }}" class="btn btn-outline-success text-start">
                            <i class="ti ti-percentage me-2"></i>Tax Configurations
                        </a>
                        <a href="{{ route('admin.countries.index') }}" class="btn btn-outline-info text-start">
                            <i class="ti ti-flag me-2"></i>Manage Countries
                        </a>
                        <a href="{{ route('admin.exchange-rates.index') }}" class="btn btn-outline-warning text-start">
                            <i class="ti ti-currency-dollar me-2"></i>Exchange Rates
                        </a>
                        <a href="{{ route('admin.tax-calculator') }}" class="btn btn-outline-secondary text-start">
                            <i class="ti ti-calculator-filled me-2"></i>Tax Calculator
                        </a>
                    </div>
                </div>
            </div>

            <!-- System Status -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-transparent border-0 py-3">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="ti ti-device-desktop me-2"></i>System Status
                    </h5>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div class="d-flex align-items-center">
                                <i class="ti ti-barcode text-primary me-2"></i>
                                <span>HS Codes</span>
                            </div>
                            <span class="badge bg-primary rounded-pill">{{ $stats['total_hs_codes'] }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div class="d-flex align-items-center">
                                <i class="ti ti-world text-success me-2"></i>
                                <span>Active Countries</span>
                            </div>
                            <span class="badge bg-success rounded-pill">{{ $stats['total_countries'] }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div class="d-flex align-items-center">
                                <i class="ti ti-percentage text-warning me-2"></i>
                                <span>Tax Rules</span>
                            </div>
                            <span class="badge bg-warning rounded-pill">{{ $stats['active_tax_rules'] }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div class="d-flex align-items-center">
                                <i class="ti ti-calculator text-info me-2"></i>
                                <span>Today's Calculations</span>
                            </div>
                            <span class="badge bg-info rounded-pill">{{ $stats['today_calculations'] }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div class="d-flex align-items-center">
                                <i class="ti ti-currency-dollar {{ $exchangeRatesStatus ? 'text-success' : 'text-warning' }} me-2"></i>
                                <span>Exchange Rates</span>
                            </div>
                            <span class="badge bg-{{ $exchangeRatesStatus ? 'success' : 'warning' }} rounded-pill">
                                {{ $exchangeRatesStatus ? 'Updated' : 'Pending' }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Popular HS Codes -->
            @if($popularHsCodes->count() > 0)
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-transparent border-0 py-3">
                    <h5 class="card-title mb-0 fw-bold">
                        <i class="ti ti-trending-up me-2"></i>Popular HS Codes
                    </h5>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        @foreach($popularHsCodes as $hsCode)
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div>
                                <div class="fw-semibold">{{ $hsCode['code'] }}</div>
                                <small class="text-muted">{{ Str::limit($hsCode['description'], 30) }}</small>
                            </div>
                            <span class="badge bg-light text-dark rounded-pill">{{ $hsCode['count'] }}</span>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>

</div>

<style>
.card {
    border: none;
    transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
}

.card:hover {
    transform: translateY(-2px);
}

.avatar-sm {
    width: 48px;
    height: 48px;
}

.avatar-lg {
    width: 80px;
    height: 80px;
}

.avatar-xs {
    width: 32px;
    height: 32px;
}

.list-group-item {
    border: none;
    padding: 0.75rem 0;
}

.btn-outline-primary, .btn-outline-success, .btn-outline-info, .btn-outline-warning {
    border: 1px solid;
    transition: all 0.2s ease-in-out;
}

.btn-outline-primary:hover { background-color: var(--bs-primary); color: white; }
.btn-outline-success:hover { background-color: var(--bs-success); color: white; }
.btn-outline-info:hover { background-color: var(--bs-info); color: white; }
.btn-outline-warning:hover { background-color: var(--bs-warning); color: white; }
</style>
@endsection