@extends('layouts.admin')

@section('title', $currency->name . ' - Currency Details')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-money-bill-wave me-2"></i>Currency Details: {{ $currency->name }}
                        </h4>
                        <div class="btn-group">
                            <a href="{{ route('admin.currencies.index') }}" class="btn btn-light btn-sm">
                                <i class="fas fa-arrow-left me-1"></i>Back to Currencies
                            </a>
                            <a href="{{ route('admin.currencies.edit', $currency->id) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit me-1"></i>Edit
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Currency Information -->
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Currency Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold" width="40%">Currency Name</td>
                                                    <td>{{ $currency->name }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Currency Code</td>
                                                    <td>
                                                        <span class="badge bg-{{ $currency->code == 'KES' ? 'success' : 'primary' }}">
                                                            {{ $currency->code }}
                                                        </span>
                                                        @if($currency->code == 'KES')
                                                            <span class="badge bg-success ms-2">Base Currency</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Symbol</td>
                                                    <td>{{ $currency->symbol ?? '—' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Decimal Places</td>
                                                    <td>{{ $currency->decimal_places }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Status</td>
                                                    <td>
                                                        @if($currency->active)
                                                            <span class="badge bg-success">Active</span>
                                                        @else
                                                            <span class="badge bg-secondary">Inactive</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Created</td>
                                                    <td>{{ $currency->created_at->format('M j, Y H:i') }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Last Updated</td>
                                                    <td>{{ $currency->updated_at->format('M j, Y H:i') }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0"><i class="fas fa-chart-line me-2"></i>Exchange Rate Statistics</h5>
                                </div>
                                <div class="card-body">
                                    @php
                                        $latestRate = $currency->latestRate;
                                        $totalRates = $currency->exchangeRates()->count();
                                        $activeRates = $currency->exchangeRates()->where('is_active', true)->count();
                                        $todayRates = $currency->exchangeRates()->whereDate('effective_date', today())->count();
                                    @endphp
                                    
                                    <div class="row text-center">
                                        <div class="col-6 mb-3">
                                            <div class="card bg-primary text-white">
                                                <div class="card-body py-3">
                                                    <h3 class="mb-0">{{ $totalRates }}</h3>
                                                    <small>Total Rates</small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-6 mb-3">
                                            <div class="card bg-success text-white">
                                                <div class="card-body py-3">
                                                    <h3 class="mb-0">{{ $activeRates }}</h3>
                                                    <small>Active Rates</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    @if($latestRate)
                                    <div class="mt-3 p-3 bg-light rounded">
                                        <h6 class="text-primary">Current Exchange Rate</h6>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong>1 {{ $currency->code }} = {{ number_format($latestRate->rate, 4) }} KES</strong>
                                            </div>
                                            <div class="text-muted small">
                                                Effective: {{ $latestRate->effective_date->format('M j, Y') }}
                                            </div>
                                        </div>
                                        @if($latestRate->effective_date->isToday())
                                            <span class="badge bg-success mt-2">Current</span>
                                        @else
                                            <span class="badge bg-warning mt-2">Historical</span>
                                        @endif
                                    </div>
                                    @else
                                    <div class="text-center py-4">
                                        <i class="fas fa-exclamation-triangle text-warning fa-2x mb-3"></i>
                                        <p class="text-muted">No exchange rates found for this currency.</p>
                                        <a href="{{ route('admin.exchange-rates.create') }}?target_currency={{ $currency->code }}" 
                                           class="btn btn-primary btn-sm">
                                            <i class="fas fa-plus me-1"></i>Add Exchange Rate
                                        </a>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Exchange Rate History -->
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-light d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="fas fa-history me-2"></i>Exchange Rate History
                                <span class="badge bg-primary ms-2">{{ $exchangeRates->total() }}</span>
                            </h5>
                            <a href="{{ route('admin.exchange-rates.create') }}?target_currency={{ $currency->code }}" 
                               class="btn btn-primary btn-sm">
                                <i class="fas fa-plus me-1"></i>Add New Rate
                            </a>
                        </div>
                        <div class="card-body">
                            @if($exchangeRates->count())
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Base Currency</th>
                                            <th>Target Currency</th>
                                            <th>Exchange Rate</th>
                                            <th>Effective Date</th>
                                            <th>Status</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($exchangeRates as $rate)
                                        <tr>
                                            <td>
                                                <span class="badge bg-success">{{ $rate->base_currency }}</span>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary">{{ $rate->target_currency }}</span>
                                            </td>
                                            <td>
                                                <strong>1 {{ $rate->target_currency }} = {{ number_format($rate->rate, 4) }} {{ $rate->base_currency }}</strong>
                                            </td>
                                            <td>{{ $rate->effective_date->format('M j, Y') }}</td>
                                            <td>
                                                @if($rate->is_active)
                                                    <span class="badge bg-success">Active</span>
                                                @else
                                                    <span class="badge bg-secondary">Inactive</span>
                                                @endif
                                            </td>
                                            <td>
                                                <small class="text-muted">{{ $rate->created_at->format('M j, Y') }}</small>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="{{ route('admin.exchange-rates.edit', $rate->id) }}" 
                                                       class="btn btn-warning" title="Edit Rate">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @if($rate->is_active)
                                                    <form action="{{ route('admin.exchange-rates.destroy', $rate->id) }}" 
                                                          method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger" 
                                                                title="Deactivate Rate"
                                                                onclick="return confirm('Are you sure you want to deactivate this exchange rate?')">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </form>
                                                    @else
                                                    <form action="{{ route('admin.exchange-rates.update', $rate->id) }}" 
                                                          method="POST" class="d-inline">
                                                        @csrf
                                                        @method('PUT')
                                                        <input type="hidden" name="is_active" value="1">
                                                        <button type="submit" class="btn btn-success" 
                                                                title="Activate Rate"
                                                                onclick="return confirm('Are you sure you want to activate this exchange rate?')">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                    </form>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="d-flex justify-content-between align-items-center mt-3">
                                <div class="text-muted">
                                    Showing {{ $exchangeRates->firstItem() }} to {{ $exchangeRates->lastItem() }} of {{ $exchangeRates->total() }} exchange rates
                                </div>
                                {{ $exchangeRates->links() }}
                            </div>
                            @else
                            <div class="text-center py-5">
                                <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">No Exchange Rates Found</h5>
                                <p class="text-muted mb-4">No exchange rates have been added for this currency yet.</p>
                                <a href="{{ route('admin.exchange-rates.create') }}?target_currency={{ $currency->code }}" 
                                   class="btn btn-primary">
                                    <i class="fas fa-plus me-2"></i>Add First Exchange Rate
                                </a>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="row mt-4">
                        <div class="col-md-4">
                            <div class="card border-success text-center">
                                <div class="card-body">
                                    <i class="fas fa-sync text-success fa-2x mb-3"></i>
                                    <h5>Update Rate</h5>
                                    <p class="text-muted small">Add a new exchange rate for this currency</p>
                                    <a href="{{ route('admin.exchange-rates.create') }}?target_currency={{ $currency->code }}" 
                                       class="btn btn-success btn-sm">
                                        Update Rate
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-primary text-center">
                                <div class="card-body">
                                    <i class="fas fa-chart-line text-primary fa-2x mb-3"></i>
                                    <h5>View Analytics</h5>
                                    <p class="text-muted small">View rate history and trends</p>
                                    <a href="#" class="btn btn-primary btn-sm" onclick="alert('Analytics feature coming soon!')">
                                        View Analytics
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-info text-center">
                                <div class="card-body">
                                    <i class="fas fa-calculator text-info fa-2x mb-3"></i>
                                    <h5>Test Conversion</h5>
                                    <p class="text-muted small">Test currency conversion</p>
                                    <a href="{{ route('admin.tax-calculator') }}?currency={{ $currency->code }}" 
                                       class="btn btn-info btn-sm">
                                        Test Conversion
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.card {
    border-radius: 10px;
}

.table th {
    border-top: none;
    font-weight: 600;
}

.btn {
    border-radius: 6px;
}

.badge {
    font-size: 0.75em;
}
</style>
@endpush