@extends('layouts.admin')

@section('title', 'Currencies & Exchange Rates')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Currencies & Exchange Rates</h2>
                <div>
                    <a href="{{ route('admin.currencies.create') }}" class="btn btn-primary me-2">
                        <i class="fas fa-plus me-2"></i>Add Currency
                    </a>
                    <a href="{{ route('admin.exchange-rates.create') }}" class="btn btn-success">
                        <i class="fas fa-plus me-2"></i>Add Exchange Rate
                    </a>
                </div>
            </div>
            <p class="text-muted">Manage currencies and their exchange rates</p>
        </div>
    </div>
</div>

@include('partials.admin.alerts')

<!-- Current Exchange Rates -->
<div class="card">
    <div class="card-header">
        <h4 class="mb-0">Current Exchange Rates (Base: KES)</h4>
    </div>
    <div class="card-body">
        @if(isset($currentRates) && $currentRates->count())
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Currency</th>
                        <th>Code</th>
                        <th>Exchange Rate</th>
                        <th>Last Updated</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($currentRates as $rate)
                    <tr>
                        <td>
                            <strong>{{ $rate->targetCurrency->name ?? 'N/A' }}</strong>
                        </td>
                        <td>
                            <span class="badge bg-primary">{{ $rate->target_currency }}</span>
                        </td>
                        <td>
                            <strong>1 {{ $rate->target_currency }} = {{ number_format($rate->rate, 4) }} KES</strong>
                        </td>
                        <td>{{ $rate->effective_date->format('M j, Y') }}</td>
                        <td>
                            @if($rate->effective_date->isToday())
                                <span class="badge bg-success">Current</span>
                            @else
                                <span class="badge bg-warning">Historical</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('admin.exchange-rates.edit', $rate->id) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="text-center py-4">
            <i class="fas fa-exchange-alt fa-3x text-muted mb-3"></i>
            <p class="text-muted">No current exchange rates found.</p>
            <a href="{{ route('admin.exchange-rates.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add First Exchange Rate
            </a>
        </div>
        @endif
    </div>
</div>

<!-- Currencies Management -->
<div class="card mt-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">Currencies Management</h4>
        <a href="{{ route('admin.currencies.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add Currency
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Currency Name</th>
                        <th>Code</th>
                        <th>Symbol</th>
                        <th>Decimal Places</th>
                        <th>Status</th>
                        <th>Last Rate Update</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($currencies ?? [] as $currency)
                    <tr>
                        <td>
                            <strong>{{ $currency->name }}</strong>
                        </td>
                        <td>
                            <span class="badge bg-{{ $currency->code == 'KES' ? 'success' : 'primary' }}">
                                {{ $currency->code }}
                            </span>
                        </td>
                        <td>
                            {{ $currency->symbol ?? '—' }}
                        </td>
                        <td>
                            {{ $currency->decimal_places }}
                        </td>
                        <td>
                            @if($currency->active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            @if($currency->latestRate)
                                {{ $currency->latestRate->effective_date->format('M j, Y') }}
                            @else
                                <span class="text-muted">No rates</span>
                            @endif
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.currencies.edit', $currency->id) }}" 
                                   class="btn btn-warning" title="Edit Currency">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="{{ route('admin.currencies.show', $currency->id) }}" 
                                   class="btn btn-info" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @if($currency->code != 'KES')
                                <form action="{{ route('admin.currencies.destroy', $currency->id) }}" 
                                      method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger" 
                                            title="Delete Currency"
                                            onclick="return confirm('Are you sure you want to delete this currency?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-money-bill-wave fa-3x mb-3"></i>
                            <p>No currencies found.</p>
                            <a href="{{ route('admin.currencies.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-2"></i>Add First Currency
                            </a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if(isset($currencies) && $currencies->count())
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div class="text-muted">
                Showing {{ $currencies->firstItem() }} to {{ $currencies->lastItem() }} of {{ $currencies->total() }} currencies
            </div>
            {{ $currencies->links() }}
        </div>
        @endif
    </div>
</div>

<!-- Exchange Rate History -->
<div class="card mt-4">
    <div class="card-header">
        <h4 class="mb-0">Exchange Rate History</h4>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.currencies.index') }}" method="GET" class="mb-3">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="currency">Currency</label>
                        <select class="form-control" id="currency" name="currency">
                            <option value="">All Currencies</option>
                            @foreach($currencies ?? [] as $currency)
                                @if($currency->code != 'KES')
                                <option value="{{ $currency->code }}" 
                                    {{ request('currency') == $currency->code ? 'selected' : '' }}>
                                    {{ $currency->code }} - {{ $currency->name }}
                                </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="date_from">From Date</label>
                        <input type="date" class="form-control" id="date_from" name="date_from" 
                               value="{{ request('date_from') }}">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="date_to">To Date</label>
                        <input type="date" class="form-control" id="date_to" name="date_to" 
                               value="{{ request('date_to') }}">
                    </div>
                </div>
            </div>
            <button type="submit" class="btn btn-primary">Filter History</button>
            <a href="{{ route('admin.currencies.index') }}" class="btn btn-secondary">Clear Filters</a>
        </form>

        @if(isset($historicalRates) && $historicalRates->count())
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Base Currency</th>
                        <th>Target Currency</th>
                        <th>Exchange Rate</th>
                        <th>Effective Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($historicalRates as $rate)
                    <tr>
                        <td>
                            <span class="badge bg-success">{{ $rate->base_currency }}</span>
                        </td>
                        <td>
                            <span class="badge bg-primary">{{ $rate->target_currency }}</span>
                        </td>
                        <td>
                            <strong>1 {{ $rate->target_currency }} = {{ number_format($rate->rate, 4) }} {{ $rate->base_currency }}</strong>
                        </td>
                        <td>{{ $rate->effective_date->format('M j, Y') }}</td>
                        <td>
                            @if($rate->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('admin.exchange-rates.edit', $rate->id) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="mt-3">
            {{ $historicalRates->links() }}
        </div>
        @else
        <div class="text-center py-4">
            <i class="fas fa-history fa-3x text-muted mb-3"></i>
            <p class="text-muted">No historical exchange rates found.</p>
            @if(request()->anyFilled(['currency', 'date_from', 'date_to']))
                <a href="{{ route('admin.currencies.index') }}" class="btn btn-secondary">Clear Filters</a>
            @else
                <a href="{{ route('admin.exchange-rates.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Exchange Rate
                </a>
            @endif
        </div>
        @endif
    </div>
</div>

<!-- Quick Update Form -->
<div class="card mt-4">
    <div class="card-header">
        <h4 class="mb-0">Quick Exchange Rate Update</h4>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.exchange-rates.quick-update') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="target_currency">Currency</label>
                        <select class="form-control" id="target_currency" name="target_currency" required>
                            <option value="">Select Currency</option>
                            @foreach($currencies ?? [] as $currency)
                                @if($currency->code != 'KES' && $currency->active)
                                <option value="{{ $currency->code }}">
                                    {{ $currency->code }} - {{ $currency->name }}
                                </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="rate">Exchange Rate (1 Unit = X KES)</label>
                        <input type="number" step="0.0001" class="form-control" id="rate" name="rate" 
                               placeholder="e.g., 150.50" required>
                        <small class="form-text text-muted">Enter the rate for 1 unit of foreign currency in KES</small>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="effective_date">Effective Date</label>
                        <input type="date" class="form-control" id="effective_date" name="effective_date" 
                               value="{{ date('Y-m-d') }}" required>
                    </div>
                </div>
            </div>
            <button type="submit" class="btn btn-success">
                <i class="fas fa-sync me-2"></i>Update Exchange Rate
            </button>
        </form>
    </div>
</div>
@endsection