@extends('layouts.admin')

@section('title', 'Edit Currency: ' . $currency->name)

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-edit me-2"></i>Edit Currency: {{ $currency->name }}
                        </h4>
                        <a href="{{ route('admin.currencies.index') }}" class="btn btn-light btn-sm">
                            <i class="fas fa-arrow-left me-1"></i>Back to Currencies
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.currencies.update', $currency->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="code" class="form-label fw-semibold">Currency Code *</label>
                                    <input type="text" class="form-control @error('code') is-invalid @enderror" 
                                           id="code" name="code" value="{{ old('code', $currency->code) }}" 
                                           maxlength="3" required {{ $currency->code == 'KES' ? 'readonly' : '' }}>
                                    <div class="form-text">3-letter ISO currency code</div>
                                    @error('code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label fw-semibold">Currency Name *</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name', $currency->name) }}" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="symbol" class="form-label fw-semibold">Symbol</label>
                                    <input type="text" class="form-control @error('symbol') is-invalid @enderror" 
                                           id="symbol" name="symbol" value="{{ old('symbol', $currency->symbol) }}" 
                                           maxlength="10">
                                    <div class="form-text">Currency symbol (e.g., $, €, £)</div>
                                    @error('symbol')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="decimal_places" class="form-label fw-semibold">Decimal Places *</label>
                                    <input type="number" class="form-control @error('decimal_places') is-invalid @enderror" 
                                           id="decimal_places" name="decimal_places" 
                                           value="{{ old('decimal_places', $currency->decimal_places) }}" 
                                           min="0" max="6" required>
                                    <div class="form-text">Number of decimal places (0-6)</div>
                                    @error('decimal_places')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="active" name="active" 
                                               value="1" {{ old('active', $currency->active) ? 'checked' : '' }}>
                                        <label class="form-check-label fw-semibold" for="active">
                                            Active Currency
                                        </label>
                                    </div>
                                    <div class="form-text">Inactive currencies won't be available for calculations</div>
                                </div>
                            </div>
                        </div>

                        @if($currency->code == 'KES')
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Base Currency:</strong> This is the base currency (KES). Some settings cannot be modified.
                        </div>
                        @endif

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <a href="{{ route('admin.currencies.index') }}" class="btn btn-secondary me-md-2">
                                <i class="fas fa-times me-2"></i>Cancel
                            </a>
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save me-2"></i>Update Currency
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <!-- Currency Statistics -->
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-chart-bar me-2"></i>Currency Statistics</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">Total Exchange Rates</small>
                        <div class="fw-bold">{{ $currency->exchangeRates()->count() }}</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Active Exchange Rates</small>
                        <div class="fw-bold">{{ $currency->exchangeRates()->where('is_active', true)->count() }}</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Latest Rate Update</small>
                        <div class="fw-bold">
                            @if($currency->latestRate)
                                {{ $currency->latestRate->effective_date->format('M j, Y') }}
                            @else
                                <span class="text-muted">Never</span>
                            @endif
                        </div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Created</small>
                        <div class="fw-bold">{{ $currency->created_at->format('M j, Y') }}</div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card border-success mt-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-bolt me-2"></i>Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.currencies.show', $currency->id) }}" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-eye me-1"></i>View Details
                        </a>
                        <a href="{{ route('admin.exchange-rates.create') }}?target_currency={{ $currency->code }}" 
                           class="btn btn-outline-success btn-sm">
                            <i class="fas fa-plus me-1"></i>Add Exchange Rate
                        </a>
                        @if($currency->code != 'KES')
                        <form action="{{ route('admin.currencies.destroy', $currency->id) }}" method="POST" class="d-grid">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-outline-danger btn-sm" 
                                    onclick="return confirm('Are you sure you want to delete this currency? This action cannot be undone.')">
                                <i class="fas fa-trash me-1"></i>Delete Currency
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection