@extends('layouts.admin')

@section('title', 'Country Duty Override Details')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Country Duty Override Details</h4>
                <a href="{{ route('admin.country-overrides.index') }}" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left me-1"></i>Back to List
                </a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Country:</strong> {{ $countryOverride->country->name }} ({{ $countryOverride->country->code }})</p>
                        <p><strong>HS Code:</strong> {{ $countryOverride->hsCode->hs_code }}</p>
                        <p><strong>Description:</strong> {{ $countryOverride->hsCode->description }}</p>
                        <p><strong>Duty Type:</strong> <span class="badge bg-info text-capitalize">{{ $countryOverride->duty_type }}</span></p>
                        <p><strong>Duty Value:</strong> 
                            @if($countryOverride->duty_type === 'percentage')
                                {{ $countryOverride->duty_value }}%
                            @else
                                {{ number_format($countryOverride->duty_value, 2) }}
                            @endif
                        </p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Status:</strong> 
                            @if($countryOverride->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </p>
                        <p><strong>Effective From:</strong> {{ $countryOverride->effective_from->format('M j, Y') }}</p>
                        <p><strong>Effective To:</strong> 
                            @if($countryOverride->effective_to)
                                {{ $countryOverride->effective_to->format('M j, Y') }}
                            @else
                                <span class="text-success">Ongoing</span>
                            @endif
                        </p>
                        <p><strong>Created:</strong> {{ $countryOverride->created_at->format('M j, Y H:i') }}</p>
                        <p><strong>Last Updated:</strong> {{ $countryOverride->updated_at->format('M j, Y H:i') }}</p>
                    </div>
                </div>
                
                @if($countryOverride->remarks)
                <div class="row mt-3">
                    <div class="col-12">
                        <h5>Remarks</h5>
                        <p class="bg-light p-3 rounded">{{ $countryOverride->remarks }}</p>
                    </div>
                </div>
                @endif
            </div>
            <div class="card-footer">
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.country-overrides.edit', $countryOverride->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <a href="{{ route('admin.country-overrides.clone', $countryOverride->id) }}" class="btn btn-secondary">
                        <i class="fas fa-copy me-2"></i>Clone
                    </a>
                    <form action="{{ route('admin.country-overrides.destroy', $countryOverride->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this override?')">
                            <i class="fas fa-trash me-2"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection