@extends('layouts.admin')

@section('title', 'Country Duty Overrides')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Country Duty Overrides</h2>
                <a href="{{ route('admin.country-overrides.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Override
                </a>
            </div>
            <p class="text-muted">Manage country-specific duty rates for HS codes</p>
        </div>
    </div>
</div>

@include('partials.admin.alerts')

<!-- Search and Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form action="{{ route('admin.country-overrides.index') }}" method="GET">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="search">Search HS Code, Description or Country</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" placeholder="Search...">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="country_code">Country</label>
                        <select class="form-control" id="country_code" name="country_code">
                            <option value="">All Countries</option>
                            @foreach($countries as $country)
                                <option value="{{ $country->code }}" {{ request('country_code') == $country->code ? 'selected' : '' }}>
                                    {{ $country->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="duty_type">Duty Type</label>
                        <select class="form-control" id="duty_type" name="duty_type">
                            <option value="">All Types</option>
                            <option value="percentage" {{ request('duty_type') == 'percentage' ? 'selected' : '' }}>Percentage</option>
                            <option value="flat" {{ request('duty_type') == 'flat' ? 'selected' : '' }}>Flat Rate</option>
                            <option value="per_kg" {{ request('duty_type') == 'per_kg' ? 'selected' : '' }}>Per KG</option>
                            <option value="per_container" {{ request('duty_type') == 'per_container' ? 'selected' : '' }}>Per Container</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Country Overrides Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">Country Duty Overrides</h4>
        <a href="{{ route('admin.country-overrides.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add New
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Country</th>
                        <th>HS Code</th>
                        <th>Description</th>
                        <th>Duty Type</th>
                        <th>Duty Value</th>
                        <th>Effective Period</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($overrides as $override)
                    <tr>
                        <td>
                            <strong>{{ $override->country->code }}</strong>
                            <br>
                            <small class="text-muted">{{ $override->country->name }}</small>
                            @if($override->country->region)
                                <br>
                                <span class="badge bg-info">{{ $override->country->region }}</span>
                            @endif
                        </td>
                        <td>
                            <strong>{{ $override->hsCode->hs_code }}</strong>
                        </td>
                        <td>
                            <span title="{{ $override->hsCode->description }}">
                                {{ Str::limit($override->hsCode->description, 40) }}
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-info text-capitalize">{{ $override->duty_type }}</span>
                        </td>
                        <td>
                            @if($override->duty_type === 'percentage')
                                {{ $override->duty_value }}%
                            @else
                                {{ number_format($override->duty_value, 2) }}
                            @endif
                        </td>
                        <td>
                            <small>
                                {{ $override->effective_from->format('M j, Y') }}
                                @if($override->effective_to)
                                    <br>to {{ $override->effective_to->format('M j, Y') }}
                                @else
                                    <br><span class="text-success">Ongoing</span>
                                @endif
                            </small>
                        </td>
                        <td>
                            @if($override->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.country-overrides.show', $override->id) }}" class="btn btn-info btn-sm" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.country-overrides.edit', $override->id) }}" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="{{ route('admin.country-overrides.clone', $override->id) }}" class="btn btn-secondary btn-sm" title="Clone">
                                    <i class="fas fa-copy"></i>
                                </a>
                                <form action="{{ route('admin.country-overrides.destroy', $override->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" title="Delete" onclick="return confirm('Are you sure you want to delete this override?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        @if($overrides->hasPages())
            <div class="mt-3">
                {{ $overrides->links() }}
            </div>
        @endif
    </div>
</div>
@endsection