@extends('layouts.admin')

@section('title', 'Edit Country Duty Override')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Edit Country Duty Override</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.country-overrides.update', $countryOverride->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="country_code" class="form-label">Country *</label>
                                <select class="form-control @error('country_code') is-invalid @enderror" 
                                        id="country_code" name="country_code" required>
                                    <option value="">Select Country</option>
                                    @foreach($countries as $country)
                                        <option value="{{ $country->code }}" {{ old('country_code', $countryOverride->country_code) == $country->code ? 'selected' : '' }}>
                                            {{ $country->name }} ({{ $country->code }})
                                            @if($country->region)
                                                - {{ $country->region }}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('country_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hs_code_id" class="form-label">HS Code *</label>
                                <select class="form-control @error('hs_code_id') is-invalid @enderror" 
                                        id="hs_code_id" name="hs_code_id" required>
                                    <option value="">Select HS Code</option>
                                    @foreach($hsCodes as $hsCode)
                                        <option value="{{ $hsCode->id }}" {{ old('hs_code_id', $countryOverride->hs_code_id) == $hsCode->id ? 'selected' : '' }}>
                                            {{ $hsCode->hs_code }} - {{ Str::limit($hsCode->description, 50) }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('hs_code_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="duty_type" class="form-label">Duty Type *</label>
                                <select class="form-control @error('duty_type') is-invalid @enderror" 
                                        id="duty_type" name="duty_type" required>
                                    <option value="">Select Duty Type</option>
                                    <option value="percentage" {{ old('duty_type', $countryOverride->duty_type) == 'percentage' ? 'selected' : '' }}>Percentage</option>
                                    <option value="flat" {{ old('duty_type', $countryOverride->duty_type) == 'flat' ? 'selected' : '' }}>Flat Rate</option>
                                    <option value="per_kg" {{ old('duty_type', $countryOverride->duty_type) == 'per_kg' ? 'selected' : '' }}>Per KG</option>
                                    <option value="per_container" {{ old('duty_type', $countryOverride->duty_type) == 'per_container' ? 'selected' : '' }}>Per Container</option>
                                </select>
                                @error('duty_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="duty_value" class="form-label">Duty Value *</label>
                                <input type="number" step="0.0001" class="form-control @error('duty_value') is-invalid @enderror" 
                                       id="duty_value" name="duty_value" value="{{ old('duty_value', $countryOverride->duty_value) }}" required>
                                @error('duty_value')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_from" class="form-label">Effective From *</label>
                                <input type="date" class="form-control @error('effective_from') is-invalid @enderror" 
                                       id="effective_from" name="effective_from" value="{{ old('effective_from', $countryOverride->effective_from->format('Y-m-d')) }}" required>
                                @error('effective_from')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_to" class="form-label">Effective To</label>
                                <input type="date" class="form-control @error('effective_to') is-invalid @enderror" 
                                       id="effective_to" name="effective_to" value="{{ old('effective_to', $countryOverride->effective_to ? $countryOverride->effective_to->format('Y-m-d') : '') }}">
                                @error('effective_to')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea class="form-control @error('remarks') is-invalid @enderror" 
                                  id="remarks" name="remarks" rows="3">{{ old('remarks', $countryOverride->remarks) }}</textarea>
                        @error('remarks')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Override
                        </button>
                        <a href="{{ route('admin.country-overrides.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection