@extends('layouts.admin')

@section('title', 'Country Details')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0">{{ $country->name }}</h4>
                <a href="{{ route('admin.countries.index') }}" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left me-1"></i>Back to List
                </a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Country Code:</strong> {{ $country->code }}</p>
                        <p><strong>Country Name:</strong> {{ $country->name }}</p>
                        <p><strong>Region:</strong> 
                            @if($country->region)
                                <span class="badge bg-info">{{ $country->region }}</span>
                            @else
                                <span class="text-muted">Not specified</span>
                            @endif
                        </p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Status:</strong> 
                            @if($country->active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </p>
                        <p><strong>Created:</strong> {{ $country->created_at->format('M j, Y H:i') }}</p>
                        <p><strong>Last Updated:</strong> {{ $country->updated_at->format('M j, Y H:i') }}</p>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.countries.edit', $country->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <form action="{{ route('admin.countries.destroy', $country->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this country?')">
                            <i class="fas fa-trash me-2"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection