@extends('layouts.admin')

@section('title', 'Countries Management')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Countries Management</h2>
                <a href="{{ route('admin.countries.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Country
                </a>
            </div>
            <p class="text-muted">Manage countries and trade regions for duty calculations</p>
        </div>
    </div>
</div>

@include('partials.admin.alerts')

<!-- Search and Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form action="{{ route('admin.countries.index') }}" method="GET">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="search">Search</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" placeholder="Search country name or code...">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="region">Region</label>
                        <select class="form-control" id="region" name="region">
                            <option value="">All Regions</option>
                            <option value="EAC" {{ request('region') == 'EAC' ? 'selected' : '' }}>EAC</option>
                            <option value="COMESA" {{ request('region') == 'COMESA' ? 'selected' : '' }}>COMESA</option>
                            <option value="EU" {{ request('region') == 'EU' ? 'selected' : '' }}>European Union</option>
                            <option value="OTHER" {{ request('region') == 'OTHER' ? 'selected' : '' }}>Other</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="active">Status</label>
                        <select class="form-control" id="active" name="active">
                            <option value="">All Status</option>
                            <option value="1" {{ request('active') == '1' ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ request('active') == '0' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Countries Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">Countries</h4>
        <a href="{{ route('admin.countries.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add New
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Code</th>
                        <th>Country Name</th>
                        <th>Region</th>
                        <th>Status</th>
                        <th>Duty Overrides</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($countries as $country)
                    <tr>
                        <td>
                            <strong>{{ $country->code }}</strong>
                        </td>
                        <td>{{ $country->name }}</td>
                        <td>
                            @if($country->region)
                                <span class="badge bg-info">{{ $country->region }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($country->active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $country->dutyOverrides()->count() > 0 ? 'warning' : 'light' }}">
                                {{ $country->dutyOverrides()->count() }} override(s)
                            </span>
                        </td>
                        <td>
                            @include('partials.admin.tables.action-buttons', [
                                'viewUrl' => route('admin.countries.show', $country->id),
                                'editUrl' => route('admin.countries.edit', $country->id),
                                'deleteUrl' => route('admin.countries.destroy', $country->id)
                            ])
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        @if($countries->hasPages())
            <div class="mt-3">
                {{ $countries->links() }}
            </div>
        @endif
    </div>
</div>
@endsection