@extends('layouts.admin')

@section('title', 'Edit Country')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Edit Country: {{ $country->name }}</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.countries.update', $country->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="code" class="form-label">Country Code *</label>
                                <input type="text" class="form-control @error('code') is-invalid @enderror" 
                                       id="code" name="code" value="{{ old('code', $country->code) }}" 
                                       maxlength="2" required>
                                @error('code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name" class="form-label">Country Name *</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                       id="name" name="name" value="{{ old('name', $country->name) }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="region" class="form-label">Trade Region</label>
                                <select class="form-control @error('region') is-invalid @enderror" 
                                        id="region" name="region">
                                    <option value="">Select Region</option>
                                    <option value="EAC" {{ old('region', $country->region) == 'EAC' ? 'selected' : '' }}>East African Community (EAC)</option>
                                    <option value="COMESA" {{ old('region', $country->region) == 'COMESA' ? 'selected' : '' }}>Common Market for Eastern and Southern Africa (COMESA)</option>
                                    <option value="EU" {{ old('region', $country->region) == 'EU' ? 'selected' : '' }}>European Union</option>
                                    <option value="OTHER" {{ old('region', $country->region) == 'OTHER' ? 'selected' : '' }}>Other</option>
                                </select>
                                @error('region')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group mt-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="active" name="active" value="1" {{ old('active', $country->active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="active">Active</label>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Country
                        </button>
                        <a href="{{ route('admin.countries.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Country Information</h5>
            </div>
            <div class="card-body">
                <p><strong>Created:</strong> {{ $country->created_at->format('M j, Y H:i') }}</p>
                <p><strong>Last Updated:</strong> {{ $country->updated_at->format('M j, Y H:i') }}</p>
                
                @if($country->dutyOverrides()->exists())
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    This country has {{ $country->dutyOverrides()->count() }} duty override(s).
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection